/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Execution;

public abstract class NeedsActiveExecutionCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;

    public NeedsActiveExecutionCmd(String executionId) {
        this.executionId = executionId;
    }

    public T execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new FlowableIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.executionId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        if (execution.isSuspended()) {
            throw new FlowableException(this.getSuspendedExceptionMessage());
        }
        return this.execute(commandContext, execution);
    }

    protected abstract T execute(CommandContext var1, ExecutionEntity var2);

    protected String getSuspendedExceptionMessage() {
        return "Cannot execution operation because execution '" + this.executionId + "' is suspended";
    }
}

