/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.api.Task;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class HasTaskVariableCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String variableName;
    protected boolean isLocal;

    public HasTaskVariableCmd(String taskId, String variableName, boolean isLocal) {
        this.taskId = taskId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    public Boolean execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        TaskEntity task = CommandContextUtil.getTaskService().getTask(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        boolean hasVariable = false;
        hasVariable = this.isLocal ? task.hasVariableLocal(this.variableName) : task.hasVariable(this.variableName);
        return hasVariable;
    }
}

