/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDecisionTableQuery;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class GetDecisionTablesForProcessDefinitionCmd
implements Command<List<DmnDecisionTable>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected DmnRepositoryService dmnRepositoryService;

    public GetDecisionTablesForProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public List<DmnDecisionTable> execute(CommandContext commandContext) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find process definition for id: " + this.processDefinitionId, ProcessDefinition.class);
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.processDefinitionId);
        if (bpmnModel == null) {
            throw new FlowableObjectNotFoundException("Cannot find bpmn model for process definition id: " + this.processDefinitionId, BpmnModel.class);
        }
        if (CommandContextUtil.getDmnRepositoryService() == null) {
            throw new FlowableException("DMN repository service is not available");
        }
        this.dmnRepositoryService = CommandContextUtil.getDmnRepositoryService();
        List<DmnDecisionTable> decisionTables = this.getDecisionTablesFromModel(bpmnModel, processDefinition);
        return decisionTables;
    }

    protected List<DmnDecisionTable> getDecisionTablesFromModel(BpmnModel bpmnModel, ProcessDefinition processDefinition) {
        HashSet<String> decisionTableKeys = new HashSet<String>();
        ArrayList<DmnDecisionTable> decisionTables = new ArrayList<DmnDecisionTable>();
        List serviceTasks = bpmnModel.getMainProcess().findFlowElementsOfType(ServiceTask.class, true);
        block0: for (ServiceTask serviceTask : serviceTasks) {
            if (!"dmn".equals(serviceTask.getType()) || serviceTask.getFieldExtensions() == null || serviceTask.getFieldExtensions().size() <= 0) continue;
            for (FieldExtension fieldExtension : serviceTask.getFieldExtensions()) {
                if (!"decisionTableReferenceKey".equals(fieldExtension.getFieldName())) continue;
                String decisionTableReferenceKey = fieldExtension.getStringValue();
                if (decisionTableKeys.contains(decisionTableReferenceKey)) continue block0;
                this.addDecisionTableToCollection(decisionTables, decisionTableReferenceKey, processDefinition);
                decisionTableKeys.add(decisionTableReferenceKey);
                continue block0;
            }
        }
        return decisionTables;
    }

    protected void addDecisionTableToCollection(List<DmnDecisionTable> decisionTables, String decisionTableKey, ProcessDefinition processDefinition) {
        DmnDecisionTableQuery decisionTableQuery = this.dmnRepositoryService.createDecisionTableQuery();
        DmnDecisionTable decisionTable = (DmnDecisionTable)decisionTableQuery.decisionTableKey(decisionTableKey).parentDeploymentId(processDefinition.getDeploymentId()).singleResult();
        if (decisionTable != null) {
            decisionTables.add(decisionTable);
        }
    }
}

