/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.common.api.io.InputStreamProvider;
import org.flowable.engine.common.api.repository.EngineDeployment;
import org.flowable.engine.common.impl.EngineDeployer;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.util.io.BytesStreamSource;
import org.flowable.engine.impl.dynamic.BaseDynamicSubProcessInjectUtil;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.DeploymentEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public abstract class AbstractDynamicInjectionCmd {
    protected void createDerivedProcessDefinitionForTask(CommandContext commandContext, String taskId) {
        TaskEntity taskEntity = CommandContextUtil.getTaskService().getTask(taskId);
        ProcessInstance processInstance = (ProcessInstance)CommandContextUtil.getExecutionEntityManager(commandContext).findById(taskEntity.getProcessInstanceId());
        this.createDerivedProcessDefinition(commandContext, processInstance);
    }

    protected void createDerivedProcessDefinitionForProcessInstance(CommandContext commandContext, String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)CommandContextUtil.getExecutionEntityManager(commandContext).findById(processInstanceId);
        this.createDerivedProcessDefinition(commandContext, processInstance);
    }

    protected void createDerivedProcessDefinition(CommandContext commandContext, ProcessInstance processInstance) {
        ProcessDefinitionEntity originalProcessDefinitionEntity = (ProcessDefinitionEntity)CommandContextUtil.getProcessDefinitionEntityManager(commandContext).findById(processInstance.getProcessDefinitionId());
        DeploymentEntity deploymentEntity = this.createDerivedDeployment(commandContext, originalProcessDefinitionEntity);
        BpmnModel bpmnModel = this.createBpmnModel(commandContext, originalProcessDefinitionEntity, deploymentEntity);
        this.storeBpmnModelAsByteArray(commandContext, bpmnModel, deploymentEntity, originalProcessDefinitionEntity.getResourceName());
        ProcessDefinitionEntity derivedProcessDefinitionEntity = this.deployDerivedDeploymentEntity(commandContext, deploymentEntity, originalProcessDefinitionEntity);
        this.updateExecutions(commandContext, derivedProcessDefinitionEntity, (ExecutionEntity)processInstance, bpmnModel);
    }

    protected DeploymentEntity createDerivedDeployment(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntitty) {
        DeploymentEntityManager deploymentEntityManager = CommandContextUtil.getDeploymentEntityManager(commandContext);
        DeploymentEntity deploymentEntity = (DeploymentEntity)deploymentEntityManager.findById(processDefinitionEntitty.getDeploymentId());
        DeploymentEntity newDeploymentEntity = (DeploymentEntity)deploymentEntityManager.create();
        newDeploymentEntity.setName(deploymentEntity.getName());
        newDeploymentEntity.setDeploymentTime(new Date());
        newDeploymentEntity.setCategory(deploymentEntity.getCategory());
        newDeploymentEntity.setKey(deploymentEntity.getKey());
        newDeploymentEntity.setTenantId(deploymentEntity.getTenantId());
        newDeploymentEntity.setDerivedFrom(deploymentEntity.getId());
        if (deploymentEntity.getDerivedFromRoot() != null) {
            newDeploymentEntity.setDerivedFromRoot(deploymentEntity.getDerivedFromRoot());
        } else {
            newDeploymentEntity.setDerivedFromRoot(deploymentEntity.getId());
        }
        deploymentEntityManager.insert(newDeploymentEntity);
        return newDeploymentEntity;
    }

    protected void storeBpmnModelAsByteArray(CommandContext commandContext, BpmnModel bpmnModel, DeploymentEntity deploymentEntity, String resourceName) {
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        byte[] bytes = bpmnXMLConverter.convertToXML(bpmnModel);
        BaseDynamicSubProcessInjectUtil.addResource(commandContext, deploymentEntity, resourceName, bytes);
    }

    protected ProcessDefinitionEntity deployDerivedDeploymentEntity(CommandContext commandContext, DeploymentEntity deploymentEntity, ProcessDefinitionEntity originalProcessDefinitionEntity) {
        HashMap<String, Object> deploymentSettings = new HashMap<String, Object>();
        deploymentSettings.put("isDerivedDeployment", true);
        deploymentSettings.put("derivedProcessDefinitionId", originalProcessDefinitionEntity.getId());
        if (originalProcessDefinitionEntity.getDerivedFromRoot() != null) {
            deploymentSettings.put("derivedProcessDefinitionRootId", originalProcessDefinitionEntity.getDerivedFromRoot());
        } else {
            deploymentSettings.put("derivedProcessDefinitionRootId", originalProcessDefinitionEntity.getId());
        }
        deploymentEntity.setNew(true);
        List<EngineDeployer> deployers = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDeploymentManager().getDeployers();
        for (EngineDeployer engineDeployer : deployers) {
            engineDeployer.deploy((EngineDeployment)deploymentEntity, deploymentSettings);
        }
        return deploymentEntity.getDeployedArtifacts(ProcessDefinitionEntity.class).get(0);
    }

    protected BpmnModel createBpmnModel(CommandContext commandContext, ProcessDefinitionEntity originalProcessDefinitionEntity, DeploymentEntity newDeploymentEntity) {
        ResourceEntity originalBpmnResource = CommandContextUtil.getResourceEntityManager(commandContext).findResourceByDeploymentIdAndResourceName(originalProcessDefinitionEntity.getDeploymentId(), originalProcessDefinitionEntity.getResourceName());
        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new BytesStreamSource(originalBpmnResource.getBytes()), false, false);
        Process process = bpmnModel.getProcessById(originalProcessDefinitionEntity.getKey());
        this.updateBpmnProcess(commandContext, process, bpmnModel, originalProcessDefinitionEntity, newDeploymentEntity);
        return bpmnModel;
    }

    protected abstract void updateBpmnProcess(CommandContext var1, Process var2, BpmnModel var3, ProcessDefinitionEntity var4, DeploymentEntity var5);

    protected void updateExecutions(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance, BpmnModel bpmnModel) {
        String previousProcessDefinitionId = processInstance.getProcessDefinitionId();
        processInstance.setProcessDefinitionId(processDefinitionEntity.getId());
        processInstance.setProcessDefinitionVersion(processDefinitionEntity.getVersion());
        List currentTasks = CommandContextUtil.getTaskService(commandContext).findTasksByProcessInstanceId(processInstance.getId());
        for (Object currentTask : currentTasks) {
            currentTask.setProcessDefinitionId(processDefinitionEntity.getId());
        }
        List currentJobs = CommandContextUtil.getJobService(commandContext).findJobsByProcessInstanceId(processInstance.getId());
        for (Object currentJob : currentJobs) {
            currentJob.setProcessDefinitionId(processDefinitionEntity.getId());
        }
        List currentTimerJobs = CommandContextUtil.getTimerJobService(commandContext).findTimerJobsByProcessInstanceId(processInstance.getId());
        for (Object currentTimerJob : currentTimerJobs) {
            currentTimerJob.setProcessDefinitionId(processDefinitionEntity.getId());
        }
        List currentSuspendedJobs = CommandContextUtil.getJobService(commandContext).findSuspendedJobsByProcessInstanceId(processInstance.getId());
        for (Object currentSuspendedJob : currentSuspendedJobs) {
            currentSuspendedJob.setProcessDefinitionId(processDefinitionEntity.getId());
        }
        List currentDeadLetterJobs = CommandContextUtil.getJobService(commandContext).findDeadLetterJobsByProcessInstanceId(processInstance.getId());
        for (Object currentDeadLetterJob : currentDeadLetterJobs) {
            currentDeadLetterJob.setProcessDefinitionId(processDefinitionEntity.getId());
        }
        List identityLinks = CommandContextUtil.getIdentityLinkService().findIdentityLinksByProcessDefinitionId(previousProcessDefinitionId);
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            identityLinkEntity.setProcessDefId(processDefinitionEntity.getId());
        }
        CommandContextUtil.getHistoryManager().updateProcessDefinitionIdInHistory(processDefinitionEntity, processInstance);
        List<ExecutionEntity> childExecutions = CommandContextUtil.getExecutionEntityManager(commandContext).findChildExecutionsByProcessInstanceId(processInstance.getId());
        for (ExecutionEntity childExecution : childExecutions) {
            childExecution.setProcessDefinitionId(processDefinitionEntity.getId());
            childExecution.setProcessDefinitionVersion(processDefinitionEntity.getVersion());
        }
        this.updateExecutions(commandContext, processDefinitionEntity, processInstance, childExecutions);
    }

    protected abstract void updateExecutions(CommandContext var1, ProcessDefinitionEntity var2, ExecutionEntity var3, List<ExecutionEntity> var4);

    protected List<GraphicInfo> createWayPoints(double x1, double y1, double x2, double y2) {
        ArrayList<GraphicInfo> wayPoints = new ArrayList<GraphicInfo>();
        wayPoints.add(new GraphicInfo(x1, y1));
        wayPoints.add(new GraphicInfo(x2, y2));
        return wayPoints;
    }

    protected List<GraphicInfo> createWayPoints(double x1, double y1, double x2, double y2, double x3, double y3) {
        List<GraphicInfo> wayPoints = this.createWayPoints(x1, y1, x2, y2);
        wayPoints.add(new GraphicInfo(x3, y3));
        return wayPoints;
    }
}

