/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.flowable.engine.impl.persistence.entity;

import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Event;

/**
 * @author Tom Baeyens
 * @author Joram Barrez
 */
public interface CommentEntity extends Comment, Event, Entity {

    String TYPE_EVENT = "event";
    String TYPE_COMMENT = "comment";

    byte[] getFullMessageBytes();

    void setFullMessageBytes(byte[] fullMessageBytes);

    void setMessage(String[] messageParts);

    void setMessage(String message);

    void setAction(String action);

}
