/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.impl.logger;

import org.flowable.engine.common.api.delegate.event.FlowableEntityEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.BaseEntityEventListener;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.test.impl.logger.DebugInfoExecutionCreated;
import org.flowable.engine.test.impl.logger.DebugInfoExecutionDeleted;
import org.flowable.engine.test.impl.logger.ProcessExecutionLogger;

public class DebugInfoEntityEventListener
extends BaseEntityEventListener {
    protected ProcessExecutionLogger processExecutionLogger;

    public DebugInfoEntityEventListener(ProcessExecutionLogger processExecutionLogger) {
        this.processExecutionLogger = processExecutionLogger;
    }

    @Override
    protected void onCreate(FlowableEvent event) {
        ExecutionEntity executionEntity = this.getExecutionEntity(event);
        if (executionEntity != null) {
            this.processExecutionLogger.executionCreated(executionEntity);
            this.processExecutionLogger.addDebugInfo(new DebugInfoExecutionCreated(executionEntity));
        }
    }

    @Override
    protected void onDelete(FlowableEvent event) {
        ExecutionEntity executionEntity = this.getExecutionEntity(event);
        if (executionEntity != null) {
            this.processExecutionLogger.executionDeleted(executionEntity);
            this.processExecutionLogger.addDebugInfo(new DebugInfoExecutionDeleted(executionEntity));
        }
    }

    protected ExecutionEntity getExecutionEntity(FlowableEvent event) {
        FlowableEntityEvent entityEvent = (FlowableEntityEvent)event;
        Object entity = entityEvent.getEntity();
        if (entity instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)entity;
            return executionEntity;
        }
        return null;
    }
}

