/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.message.AsyncHistoryJobMessageHandler;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.HistoryJobService;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class AsyncHistoryJobMessageReceiver {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected AsyncHistoryJobMessageHandler asyncHistoryJobMessageHandler;

    public AsyncHistoryJobMessageReceiver() {
    }

    public AsyncHistoryJobMessageReceiver(ProcessEngineConfigurationImpl processEngineConfiguration, AsyncHistoryJobMessageHandler asyncHistoryJobMessageHandler) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.asyncHistoryJobMessageHandler = asyncHistoryJobMessageHandler;
    }

    public void messageForJobReceived(final String jobId) {
        if (this.processEngineConfiguration == null) {
            throw new FlowableException("Programmatic error: this class needs a ProcessEngineConfigurationImpl instance");
        }
        if (this.asyncHistoryJobMessageHandler == null) {
            throw new FlowableException("Programmatic error: this class needs an AsyncHistoryJobMessageHandler instance.");
        }
        this.processEngineConfiguration.getManagementService().executeCommand(new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoryJobService historyJobService = CommandContextUtil.getHistoryJobService(commandContext);
                HistoryJobQueryImpl query = new HistoryJobQueryImpl();
                query.jobId(jobId);
                List jobs = historyJobService.findHistoryJobsByQueryCriteria(query);
                if (jobs == null || jobs.isEmpty()) {
                    throw new FlowableException("No history job found for id " + jobId);
                }
                if (jobs.size() > 1) {
                    throw new FlowableException("Multiple results for history job id " + jobId);
                }
                if (!(jobs.get(0) instanceof HistoryJobEntity)) {
                    throw new FlowableException("Job with id " + jobId + " is not an instance of history job entity, cannot handle this job");
                }
                HistoryJobEntity historyJobEntity = (HistoryJobEntity)jobs.get(0);
                if (AsyncHistoryJobMessageReceiver.this.asyncHistoryJobMessageHandler.handleJob(historyJobEntity, AsyncHistoryJobMessageReceiver.this.getHistoryJobData(historyJobEntity))) {
                    historyJobService.deleteHistoryJob(historyJobEntity);
                }
                return null;
            }
        });
    }

    protected JsonNode getHistoryJobData(HistoryJobEntity job) {
        ObjectMapper objectMapper = this.processEngineConfiguration.getObjectMapper();
        if (job.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            try {
                return objectMapper.readTree(job.getAdvancedJobHandlerConfigurationByteArrayRef().getBytes());
            }
            catch (IOException e) {
                throw new FlowableException("Could not deserialize json for history job data", (Throwable)e);
            }
        }
        return null;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public AsyncHistoryJobMessageHandler getAsyncHistoryJobMessageHandler() {
        return this.asyncHistoryJobMessageHandler;
    }

    public void setAsyncHistoryJobMessageHandler(AsyncHistoryJobMessageHandler asyncHistoryJobMessageHandler) {
        this.asyncHistoryJobMessageHandler = asyncHistoryJobMessageHandler;
    }
}

