/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractProcessInstanceDeleteHistoryTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class ProcessInstanceDeleteHistoryJsonTransformer
extends AbstractProcessInstanceDeleteHistoryTransformer {
    @Override
    public String getType() {
        return "process-instance-deleted";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        String id = this.getStringFromJson(historicalData, "processInstanceId");
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext);
        return historicProcessInstanceEntityManager.findById(id) != null;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String processInstanceId = this.getStringFromJson(historicalData, "processInstanceId");
        this.deleteProcessInstance(processInstanceId, commandContext);
    }
}

