/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.form.StartFormData;
import org.flowable.engine.impl.form.StartFormHandler;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.FormHandlerUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class GetStartFormCmd
implements Command<StartFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetStartFormCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public StartFormData execute(CommandContext commandContext) {
        ProcessDefinition processDefinition = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("No process definition found for id '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        if (Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext)) {
            return Flowable5Util.getFlowable5CompatibilityHandler().getStartFormData(this.processDefinitionId);
        }
        StartFormHandler startFormHandler = FormHandlerUtil.getStartFormHandler(commandContext, processDefinition);
        if (startFormHandler == null) {
            throw new FlowableException("No startFormHandler defined in process '" + this.processDefinitionId + "'");
        }
        return startFormHandler.createStartFormData(processDefinition);
    }
}

