/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.calendar.BusinessCalendar;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DefaultJobScopeManager
implements InternalJobManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultJobScopeManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public VariableScope resolveVariableScope(Job job) {
        return (VariableScope)this.getExecutionEntityManager().findById(job.getExecutionId());
    }

    public boolean isFlowable5ProcessDefinitionId(String processDefinitionId) {
        return Flowable5Util.isFlowable5ProcessDefinitionId(this.processEngineConfiguration, processDefinitionId);
    }

    public void executeV5Job(Job job) {
        Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
        compatibilityHandler.executeJob(job);
    }

    public void executeV5JobWithLockAndRetry(final Job job) {
        this.processEngineConfiguration.getCommandExecutor().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getFlowable5CompatibilityHandler().executeJobWithLockAndRetry(job);
                return null;
            }
        });
    }

    public boolean handleJobInsert(Job job) {
        if (job.getExecutionId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(job.getExecutionId());
            if (execution != null) {
                if (execution.getTenantId() != null) {
                    ((AbstractRuntimeJobEntity)job).setTenantId(execution.getTenantId());
                }
                CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
                if (job instanceof TimerJobEntity) {
                    TimerJobEntity timerJobEntity = (TimerJobEntity)job;
                    execution.getTimerJobs().add(timerJobEntity);
                    if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                        countingExecutionEntity.setTimerJobCount(countingExecutionEntity.getTimerJobCount() + 1);
                    }
                } else if (job instanceof JobEntity) {
                    JobEntity jobEntity = (JobEntity)job;
                    execution.getJobs().add(jobEntity);
                    if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                        countingExecutionEntity.setJobCount(countingExecutionEntity.getJobCount() + 1);
                    }
                } else if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                    if (job instanceof SuspendedJobEntity) {
                        countingExecutionEntity.setSuspendedJobCount(countingExecutionEntity.getSuspendedJobCount() + 1);
                    } else if (job instanceof DeadLetterJobEntity) {
                        countingExecutionEntity.setDeadLetterJobCount(countingExecutionEntity.getDeadLetterJobCount() + 1);
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void handleJobDelete(Job job) {
        ExecutionEntity executionEntity;
        if (job.getExecutionId() != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(executionEntity = (ExecutionEntity)this.getExecutionEntityManager().findById(job.getExecutionId()))) {
            CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)executionEntity);
            if (job instanceof JobEntity) {
                executionEntity.getJobs().remove(job);
                countingExecutionEntity.setJobCount(countingExecutionEntity.getJobCount() - 1);
            } else if (job instanceof TimerJobEntity) {
                executionEntity.getTimerJobs().remove(job);
                countingExecutionEntity.setTimerJobCount(countingExecutionEntity.getTimerJobCount() - 1);
            } else if (job instanceof SuspendedJobEntity) {
                countingExecutionEntity.setSuspendedJobCount(countingExecutionEntity.getSuspendedJobCount() - 1);
            } else if (job instanceof DeadLetterJobEntity) {
                countingExecutionEntity.setDeadLetterJobCount(countingExecutionEntity.getDeadLetterJobCount() - 1);
            }
        }
    }

    public void handleFailedJob(AbstractRuntimeJobEntity job, Throwable exception) {
        Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
        compatibilityHandler.handleFailedJob((Job)job, exception);
    }

    public void updateJobScopeLockTime(Job job) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(job.getExecutionId());
        if (execution != null) {
            executionEntityManager.updateProcessInstanceLockTime(execution.getProcessInstanceId());
        }
    }

    public void clearJobScopeLockTime(Job job) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(job.getProcessInstanceId());
        if (execution != null) {
            executionEntityManager.clearProcessInstanceLockTime(execution.getId());
        }
    }

    public void deleteV5Job(String jobId) {
        Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
        compatibilityHandler.deleteJob(jobId);
    }

    public void restoreJobExtraData(JobEntity jobEntity, VariableScope variableScope) {
        Process process;
        String activityId = jobEntity.getJobHandlerConfiguration();
        if (jobEntity.getJobHandlerType().equalsIgnoreCase("timer-start-event") || jobEntity.getJobHandlerType().equalsIgnoreCase("trigger-timer")) {
            activityId = TimerEventHandler.getActivityIdFromConfiguration(jobEntity.getJobHandlerConfiguration());
            String endDateExpressionString = TimerEventHandler.getEndDateFromConfiguration(jobEntity.getJobHandlerConfiguration());
            if (endDateExpressionString != null) {
                Expression endDateExpression = this.processEngineConfiguration.getExpressionManager().createExpression(endDateExpressionString);
                String endDateString = null;
                BusinessCalendar businessCalendar = this.processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.getCalendarNameFromConfiguration(jobEntity.getJobHandlerConfiguration()), variableScope));
                if (endDateExpression != null) {
                    Object endDateValue = endDateExpression.getValue((VariableContainer)variableScope);
                    if (endDateValue instanceof String) {
                        endDateString = (String)endDateValue;
                    } else if (endDateValue instanceof Date) {
                        jobEntity.setEndDate((Date)endDateValue);
                    } else {
                        throw new FlowableException("Timer '" + ((ExecutionEntity)variableScope).getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
                    }
                    if (jobEntity.getEndDate() == null) {
                        jobEntity.setEndDate(businessCalendar.resolveEndDate(endDateString));
                    }
                }
            }
        }
        int maxIterations = 1;
        if (jobEntity.getProcessDefinitionId() != null && (maxIterations = this.getMaxIterations(process = ProcessDefinitionUtil.getProcess(jobEntity.getProcessDefinitionId()), activityId)) <= 1) {
            maxIterations = this.getMaxIterations(process, activityId);
        }
        jobEntity.setMaxIterations(maxIterations);
    }

    protected int getMaxIterations(Process process, String activityId) {
        Event event;
        List eventDefinitions;
        FlowElement flowElement = process.getFlowElement(activityId, true);
        if (flowElement != null && flowElement instanceof Event && (eventDefinitions = (event = (Event)flowElement).getEventDefinitions()) != null) {
            for (EventDefinition eventDefinition : eventDefinitions) {
                TimerEventDefinition timerEventDefinition;
                if (!(eventDefinition instanceof TimerEventDefinition) || (timerEventDefinition = (TimerEventDefinition)eventDefinition).getTimeCycle() == null) continue;
                return this.calculateMaxIterationsValue(timerEventDefinition.getTimeCycle());
            }
        }
        return -1;
    }

    protected int calculateMaxIterationsValue(String originalExpression) {
        int times = Integer.MAX_VALUE;
        List<String> expression = Arrays.asList(originalExpression.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R")) {
            times = Integer.MAX_VALUE;
            if (expression.get(0).length() > 1) {
                times = Integer.parseInt(expression.get(0).substring(1));
            }
        }
        return times;
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = CycleBusinessCalendar.NAME;
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            businessCalendarName = (String)CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(calendarName).getValue((VariableContainer)variableScope);
        }
        return businessCalendarName;
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return this.processEngineConfiguration.getExecutionEntityManager();
    }
}

