/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.util.IoUtil;
import org.flowable.engine.impl.bpmn.deployer.ResourceNameUtil;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionDiagramHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionDiagramHelper.class);

    public ResourceEntity createDiagramForProcessDefinition(ProcessDefinitionEntity processDefinition, BpmnParse bpmnParse) {
        if (StringUtils.isEmpty((CharSequence)processDefinition.getKey()) || StringUtils.isEmpty((CharSequence)processDefinition.getResourceName())) {
            throw new IllegalStateException("Provided process definition must have both key and resource name set.");
        }
        ResourceEntity resource = this.createResourceEntity();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        try {
            byte[] diagramBytes = IoUtil.readInputStream((InputStream)processEngineConfiguration.getProcessDiagramGenerator().generateDiagram(bpmnParse.getBpmnModel(), "png", processEngineConfiguration.getActivityFontName(), processEngineConfiguration.getLabelFontName(), processEngineConfiguration.getAnnotationFontName(), processEngineConfiguration.getClassLoader()), null);
            String diagramResourceName = ResourceNameUtil.getProcessDiagramResourceName(processDefinition.getResourceName(), processDefinition.getKey(), "png");
            resource.setName(diagramResourceName);
            resource.setBytes(diagramBytes);
            resource.setDeploymentId(processDefinition.getDeploymentId());
            resource.setGenerated(true);
        }
        catch (Throwable t) {
            LOGGER.warn("Error while generating process diagram, image will not be stored in repository", t);
            resource = null;
        }
        return resource;
    }

    protected ResourceEntity createResourceEntity() {
        return (ResourceEntity)CommandContextUtil.getProcessEngineConfiguration().getResourceEntityManager().create();
    }

    public boolean shouldCreateDiagram(ProcessDefinitionEntity processDefinition, DeploymentEntity deployment) {
        if (deployment.isNew() && processDefinition.isGraphicalNotationDefined() && CommandContextUtil.getProcessEngineConfiguration().isCreateDiagramOnDeploy()) {
            return ResourceNameUtil.getProcessDiagramResourceNameFromDeployment(processDefinition, deployment.getResources()) == null;
        }
        return false;
    }
}

