/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.engine.impl.bpmn.deployer.ParsedDeployment;
import org.flowable.engine.impl.bpmn.deployer.ResourceNameUtil;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.BpmnParser;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    protected DeploymentEntity deployment;
    protected BpmnParser bpmnParser;
    protected Map<String, Object> deploymentSettings;

    public ParsedDeploymentBuilder(DeploymentEntity deployment, BpmnParser bpmnParser, Map<String, Object> deploymentSettings) {
        this.deployment = deployment;
        this.bpmnParser = bpmnParser;
        this.deploymentSettings = deploymentSettings;
    }

    public ParsedDeployment build() {
        ArrayList<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
        LinkedHashMap<ProcessDefinitionEntity, BpmnParse> processDefinitionsToBpmnParseMap = new LinkedHashMap<ProcessDefinitionEntity, BpmnParse>();
        LinkedHashMap<ProcessDefinitionEntity, ResourceEntity> processDefinitionsToResourceMap = new LinkedHashMap<ProcessDefinitionEntity, ResourceEntity>();
        for (ResourceEntity resource : this.deployment.getResources().values()) {
            if (!this.isBpmnResource(resource.getName())) continue;
            LOGGER.debug("Processing BPMN resource {}", (Object)resource.getName());
            BpmnParse parse = this.createBpmnParseFromResource(resource);
            for (ProcessDefinitionEntity processDefinition : parse.getProcessDefinitions()) {
                processDefinitions.add(processDefinition);
                processDefinitionsToBpmnParseMap.put(processDefinition, parse);
                processDefinitionsToResourceMap.put(processDefinition, resource);
            }
        }
        return new ParsedDeployment(this.deployment, processDefinitions, processDefinitionsToBpmnParseMap, processDefinitionsToResourceMap);
    }

    protected BpmnParse createBpmnParseFromResource(ResourceEntity resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        BpmnParse bpmnParse = this.bpmnParser.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        if (this.deploymentSettings != null) {
            if (this.deploymentSettings.containsKey("isBpmn20XsdValidationEnabled")) {
                bpmnParse.setValidateSchema((Boolean)this.deploymentSettings.get("isBpmn20XsdValidationEnabled"));
            }
            if (this.deploymentSettings.containsKey("isProcessValidationEnabled")) {
                bpmnParse.setValidateProcess((Boolean)this.deploymentSettings.get("isProcessValidationEnabled"));
            }
        } else {
            bpmnParse.setValidateSchema(false);
            bpmnParse.setValidateProcess(false);
        }
        try {
            bpmnParse.execute();
        }
        catch (Exception e) {
            LOGGER.error("Could not parse resource {}", (Object)resource.getName(), (Object)e);
            throw e;
        }
        return bpmnParse;
    }

    protected boolean isBpmnResource(String resourceName) {
        for (String suffix : ResourceNameUtil.BPMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

