/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.identity.Authentication;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.task.DelegationState;

public class TaskHelper {
    public static void completeTask(TaskEntity taskEntity, Map<String, Object> variables, Map<String, Object> transientVariables, boolean localScope, CommandContext commandContext) {
        FlowableEventDispatcher eventDispatcher;
        if (taskEntity.getDelegationState() != null && taskEntity.getDelegationState() == DelegationState.PENDING) {
            throw new FlowableException("A delegated task cannot be completed, but should be resolved instead.");
        }
        if (variables != null) {
            if (localScope) {
                taskEntity.setVariablesLocal(variables);
            } else if (taskEntity.getExecutionId() != null) {
                taskEntity.setExecutionVariables(variables);
            } else {
                taskEntity.setVariables(variables);
            }
        }
        if (transientVariables != null) {
            if (localScope) {
                taskEntity.setTransientVariablesLocal(transientVariables);
            } else {
                taskEntity.setTransientVariables(transientVariables);
            }
        }
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        if (Authentication.getAuthenticatedUserId() != null && taskEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(taskEntity.getProcessInstanceId());
            commandContext.getIdentityLinkEntityManager().involveUser(processInstanceEntity, Authentication.getAuthenticatedUserId(), "participant");
        }
        if ((eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher()).isEnabled()) {
            if (variables != null) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityWithVariablesEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity, variables, localScope));
            } else {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity));
            }
        }
        commandContext.getTaskEntityManager().deleteTask(taskEntity, null, false, false, true);
        if (taskEntity.getExecutionId() != null) {
            ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(taskEntity.getExecutionId());
            commandContext.getAgenda().planTriggerExecutionOperation(executionEntity);
        }
    }
}

