/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.el;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.FeatureDescriptor;
import java.math.BigDecimal;
import java.util.Iterator;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELResolver;
import org.flowable.engine.common.impl.javax.el.PropertyNotWritableException;

public class JsonNodeELResolver
extends ELResolver {
    private final boolean readOnly;

    public JsonNodeELResolver() {
        this(false);
    }

    public JsonNodeELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.isResolvable(base) ? Object.class : null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isResolvable(base)) {
            JsonNode node = (JsonNode)base;
            final Iterator keys = node.fieldNames();
            return new Iterator<FeatureDescriptor>(){

                @Override
                public boolean hasNext() {
                    return keys.hasNext();
                }

                @Override
                public FeatureDescriptor next() {
                    Object key = keys.next();
                    FeatureDescriptor feature = new FeatureDescriptor();
                    feature.setDisplayName(key == null ? "null" : key.toString());
                    feature.setName(feature.getDisplayName());
                    feature.setShortDescription("");
                    feature.setExpert(true);
                    feature.setHidden(false);
                    feature.setPreferred(true);
                    feature.setValue("type", key == null ? "null" : key.getClass());
                    feature.setValue("resolvableAtDesignTime", true);
                    return feature;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove");
                }
            };
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Class<Object> result = null;
        if (this.isResolvable(base)) {
            result = Object.class;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Object result = null;
        if (this.isResolvable(base)) {
            JsonNode resultNode = ((JsonNode)base).get(property.toString());
            result = resultNode != null && resultNode.isValueNode() ? (resultNode.isBoolean() ? Boolean.valueOf(resultNode.asBoolean()) : (resultNode.isLong() ? Long.valueOf(resultNode.asLong()) : (resultNode.isBigDecimal() || resultNode.isDouble() ? Double.valueOf(resultNode.asDouble()) : (resultNode.isTextual() ? resultNode.asText() : resultNode.toString())))) : resultNode;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.isResolvable(base)) {
            context.setPropertyResolved(true);
        }
        return this.readOnly;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (base instanceof ObjectNode) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            ObjectNode node = (ObjectNode)base;
            if (value instanceof BigDecimal) {
                node.put(property.toString(), (BigDecimal)value);
            } else if (value instanceof Boolean) {
                node.put(property.toString(), (Boolean)value);
            } else if (value instanceof Long) {
                node.put(property.toString(), (Long)value);
            } else if (value instanceof Double) {
                node.put(property.toString(), (Double)value);
            } else if (value != null) {
                node.put(property.toString(), value.toString());
            } else {
                node.putNull(property.toString());
            }
            context.setPropertyResolved(true);
        }
    }

    private final boolean isResolvable(Object base) {
        return base instanceof JsonNode;
    }
}

