/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.el;

import java.util.List;
import java.util.Map;
import org.flowable.engine.common.impl.javax.el.ArrayELResolver;
import org.flowable.engine.common.impl.javax.el.BeanELResolver;
import org.flowable.engine.common.impl.javax.el.CompositeELResolver;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELResolver;
import org.flowable.engine.common.impl.javax.el.ExpressionFactory;
import org.flowable.engine.common.impl.javax.el.ListELResolver;
import org.flowable.engine.common.impl.javax.el.MapELResolver;
import org.flowable.engine.common.impl.javax.el.ValueExpression;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.FlowableFunctionDelegate;
import org.flowable.engine.delegate.VariableScope;
import org.flowable.engine.impl.bpmn.data.ItemInstance;
import org.flowable.engine.impl.el.DynamicBeanPropertyELResolver;
import org.flowable.engine.impl.el.ExpressionManager;
import org.flowable.engine.impl.el.FlowableElContext;
import org.flowable.engine.impl.el.JsonNodeELResolver;
import org.flowable.engine.impl.el.JuelExpression;
import org.flowable.engine.impl.el.ParsingElContext;
import org.flowable.engine.impl.el.ReadOnlyMapELResolver;
import org.flowable.engine.impl.el.VariableScopeElResolver;
import org.flowable.engine.impl.interceptor.DelegateInterceptor;
import org.flowable.engine.impl.persistence.entity.VariableScopeImpl;

public abstract class AbstractExpressionManager
implements ExpressionManager {
    protected DelegateInterceptor delegateInterceptor;
    protected ExpressionFactory expressionFactory;
    protected List<FlowableFunctionDelegate> functionDelegates;
    protected ELContext parsingElContext;
    protected Map<Object, Object> beans;

    @Override
    public Expression createExpression(String expression) {
        if (this.parsingElContext == null) {
            this.parsingElContext = new ParsingElContext(this.functionDelegates);
        }
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return new JuelExpression(this, this.delegateInterceptor, valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    @Override
    public ELContext getElContext(VariableScope variableScope) {
        ELContext elContext = null;
        if (variableScope instanceof VariableScopeImpl) {
            VariableScopeImpl variableScopeImpl = (VariableScopeImpl)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof VariableScopeImpl) {
                ((VariableScopeImpl)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    protected FlowableElContext createElContext(VariableScope variableScope) {
        ELResolver elResolver = this.createElResolver(variableScope);
        return new FlowableElContext(elResolver, this.functionDelegates);
    }

    protected ELResolver createElResolver(VariableScope variableScope) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new VariableScopeElResolver(variableScope));
        if (this.beans != null) {
            elResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new JsonNodeELResolver());
        elResolver.add((ELResolver)new DynamicBeanPropertyELResolver(ItemInstance.class, "getFieldValue", "setFieldValue"));
        elResolver.add((ELResolver)new BeanELResolver());
        return elResolver;
    }

    @Override
    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    @Override
    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public List<FlowableFunctionDelegate> getFunctionDelegates() {
        return this.functionDelegates;
    }

    @Override
    public void setFunctionDelegates(List<FlowableFunctionDelegate> functionDelegates) {
        this.functionDelegates = functionDelegates;
    }
}

