/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Execution;

public class SignalEventReceivedCmd
implements Command<Void> {
    protected final String eventName;
    protected final String executionId;
    protected final Map<String, Object> payload;
    protected final boolean async;
    protected String tenantId;

    public SignalEventReceivedCmd(String eventName, String executionId, Map<String, Object> processVariables, String tenantId) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.payload = processVariables != null ? new HashMap<String, Object>(processVariables) : null;
        this.async = false;
        this.tenantId = tenantId;
    }

    public SignalEventReceivedCmd(String eventName, String executionId, boolean async, String tenantId) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.async = async;
        this.payload = null;
        this.tenantId = tenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<SignalEventSubscriptionEntity> signalEvents = null;
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        if (this.executionId == null) {
            signalEvents = eventSubscriptionEntityManager.findSignalEventSubscriptionsByEventName(this.eventName, this.tenantId);
        } else {
            ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
            if (execution == null) {
                throw new FlowableObjectNotFoundException("Cannot find execution with id '" + this.executionId + "'", Execution.class);
            }
            if (execution.isSuspended()) {
                throw new FlowableException("Cannot throw signal event '" + this.eventName + "' because execution '" + this.executionId + "' is suspended");
            }
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.signalEventReceived(this.eventName, this.executionId, this.payload, this.async, this.tenantId);
                return null;
            }
            signalEvents = eventSubscriptionEntityManager.findSignalEventSubscriptionsByNameAndExecution(this.eventName, this.executionId);
            if (signalEvents.isEmpty()) {
                throw new FlowableException("Execution '" + this.executionId + "' has not subscribed to a signal event with name '" + this.eventName + "'.");
            }
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : signalEvents) {
            if (!signalEventSubscriptionEntity.isGlobalScoped()) continue;
            if (this.executionId == null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, signalEventSubscriptionEntity.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.signalEventReceived(signalEventSubscriptionEntity, this.payload, this.async);
                continue;
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNALED, signalEventSubscriptionEntity.getActivityId(), this.eventName, this.payload, signalEventSubscriptionEntity.getExecutionId(), signalEventSubscriptionEntity.getProcessInstanceId(), signalEventSubscriptionEntity.getProcessDefinitionId()));
            eventSubscriptionEntityManager.eventReceived(signalEventSubscriptionEntity, this.payload, this.async);
        }
        return null;
    }
}

