/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.task.Task;

public abstract class NeedsActiveTaskCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public NeedsActiveTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("Cannot find task with id " + this.taskId, Task.class);
        }
        if (task.isSuspended()) {
            throw new FlowableException(this.getSuspendedTaskException());
        }
        return this.execute(commandContext, task);
    }

    protected abstract T execute(CommandContext var1, TaskEntity var2);

    protected String getSuspendedTaskException() {
        return "Cannot execute operation: task is suspended";
    }
}

