/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.history.HistoricVariableInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;

public class GetTaskFormModelCmd
implements Command<FormModel>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormModelCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public FormModel execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        if (!processEngineConfiguration.isFormEngineInitialized()) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        HistoricTaskInstance task = (HistoricTaskInstance)processEngineConfiguration.getHistoricTaskInstanceEntityManager().findById(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("Task not found with id " + this.taskId);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (task.getProcessInstanceId() != null) {
            List variableInstances = processEngineConfiguration.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
            for (HistoricVariableInstance historicVariableInstance : variableInstances) {
                variables.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
            }
        }
        String parentDeploymentId = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getProcessDefinitionId())) {
            ProcessDefinition processDefinition = processEngineConfiguration.getRepositoryService().getProcessDefinition(task.getProcessDefinitionId());
            parentDeploymentId = processDefinition.getDeploymentId();
        }
        Object formModel = null;
        formModel = task.getEndTime() != null ? processEngineConfiguration.getFormEngineFormService().getFormInstanceModelByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, this.taskId, task.getProcessInstanceId(), variables, task.getTenantId()) : processEngineConfiguration.getFormEngineFormService().getFormModelWithVariablesByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, task.getProcessInstanceId(), this.taskId, variables, task.getTenantId());
        if (formModel == null) {
            throw new FlowableObjectNotFoundException("Form model for task " + task.getTaskDefinitionKey() + " cannot be found for form key " + task.getFormKey());
        }
        this.fetchRelatedContentInfoIfNeeded((FormModel)formModel, processEngineConfiguration);
        return formModel;
    }

    protected void fetchRelatedContentInfoIfNeeded(FormModel formModel, ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (!processEngineConfiguration.isContentEngineInitialized()) {
            return;
        }
        if (formModel.getFields() != null) {
            for (FormField formField : formModel.getFields()) {
                if (!"upload".equals(formField.getType())) continue;
                ArrayList contentItemIds = null;
                if (formField.getValue() instanceof List) {
                    contentItemIds = (ArrayList)formField.getValue();
                } else if (formField.getValue() instanceof String) {
                    String[] splittedString = ((String)formField.getValue()).split(",");
                    contentItemIds = new ArrayList();
                    Collections.addAll(contentItemIds, splittedString);
                }
                if (contentItemIds == null) continue;
                HashSet contentItemIdSet = new HashSet(contentItemIds);
                List contentItems = processEngineConfiguration.getContentService().createContentItemQuery().ids(contentItemIdSet).list();
                formField.setValue((Object)contentItems);
            }
        }
    }
}

