/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.cmd.JobType;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.AbstractJobEntity;
import org.flowable.engine.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.engine.runtime.Job;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String jobId;
    protected JobType jobType;

    public GetJobExceptionStacktraceCmd(String jobId, JobType jobType) {
        this.jobId = jobId;
        this.jobType = jobType;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        AbstractJobEntity job = null;
        switch (this.jobType) {
            case ASYNC: {
                job = (AbstractRuntimeJobEntity)commandContext.getJobEntityManager().findById(this.jobId);
                break;
            }
            case TIMER: {
                job = (AbstractRuntimeJobEntity)commandContext.getTimerJobEntityManager().findById(this.jobId);
                break;
            }
            case SUSPENDED: {
                job = (AbstractRuntimeJobEntity)commandContext.getSuspendedJobEntityManager().findById(this.jobId);
                break;
            }
            case DEADLETTER: {
                job = (AbstractRuntimeJobEntity)commandContext.getDeadLetterJobEntityManager().findById(this.jobId);
            }
        }
        if (job == null) {
            throw new FlowableObjectNotFoundException("No job found with id " + this.jobId, Job.class);
        }
        return job.getExceptionStacktrace();
    }
}

