/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;

public class GetEventLogEntriesCmd
implements Command<List<EventLogEntry>> {
    protected String processInstanceId;
    protected Long startLogNr;
    protected Long pageSize;

    public GetEventLogEntriesCmd() {
    }

    public GetEventLogEntriesCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public GetEventLogEntriesCmd(Long startLogNr, Long pageSize) {
        this.startLogNr = startLogNr;
        this.pageSize = pageSize;
    }

    @Override
    public List<EventLogEntry> execute(CommandContext commandContext) {
        if (this.processInstanceId != null) {
            return commandContext.getEventLogEntryEntityManager().findEventLogEntriesByProcessInstanceId(this.processInstanceId);
        }
        if (this.startLogNr != null) {
            return commandContext.getEventLogEntryEntityManager().findEventLogEntries(this.startLogNr, this.pageSize != null ? this.pageSize : -1L);
        }
        return commandContext.getEventLogEntryEntityManager().findAllEventLogEntries();
    }
}

