/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.impl.asyncexecutor.AcquiredTimerJobEntities;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;

public class AcquireTimerJobsCmd
implements Command<AcquiredTimerJobEntities> {
    private final AsyncExecutor asyncExecutor;

    public AcquireTimerJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public AcquiredTimerJobEntities execute(CommandContext commandContext) {
        AcquiredTimerJobEntities acquiredJobs = new AcquiredTimerJobEntities();
        List<TimerJobEntity> timerJobs = commandContext.getTimerJobEntityManager().findTimerJobsToExecute(new Page(0, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition()));
        for (TimerJobEntity job : timerJobs) {
            this.lockJob(commandContext, job, this.asyncExecutor.getAsyncJobLockTimeInMillis());
            acquiredJobs.addJob(job);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, TimerJobEntity job, int lockTimeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockOwner(this.asyncExecutor.getLockOwner());
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

