/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminateEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final Logger logger = LoggerFactory.getLogger(TerminateEndEventActivityBehavior.class);
    private static final long serialVersionUID = 1L;
    protected boolean terminateAll;
    protected boolean terminateMultiInstance;

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        if (this.terminateAll) {
            this.terminateAllBehaviour(execution, commandContext, executionEntityManager);
        } else if (this.terminateMultiInstance) {
            this.terminateMultiInstanceRoot(execution, commandContext, executionEntityManager);
        } else {
            this.defaultTerminateEndEventBehaviour(execution, commandContext, executionEntityManager);
        }
    }

    protected void terminateAllBehaviour(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity rootExecutionEntity = executionEntityManager.findByRootProcessInstanceId(execution.getRootProcessInstanceId());
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        this.deleteExecutionEntities(executionEntityManager, rootExecutionEntity, execution.getCurrentFlowElement(), deleteReason);
        this.endAllHistoricActivities(rootExecutionEntity.getId(), deleteReason);
        commandContext.getHistoryManager().recordProcessInstanceEnd(rootExecutionEntity, deleteReason, execution.getCurrentActivityId());
    }

    protected void defaultTerminateEndEventBehaviour(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity scopeExecutionEntity = executionEntityManager.findFirstScope((ExecutionEntity)execution);
        String deleteReason = this.createDeleteReason(execution.getCurrentActivityId());
        if (scopeExecutionEntity.isProcessInstanceType() && scopeExecutionEntity.getSuperExecutionId() == null) {
            this.endAllHistoricActivities(scopeExecutionEntity.getId(), deleteReason);
            this.deleteExecutionEntities(executionEntityManager, scopeExecutionEntity, execution.getCurrentFlowElement(), deleteReason);
            commandContext.getHistoryManager().recordProcessInstanceEnd(scopeExecutionEntity, deleteReason, execution.getCurrentActivityId());
        } else if (scopeExecutionEntity.getCurrentFlowElement() != null && scopeExecutionEntity.getCurrentFlowElement() instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)scopeExecutionEntity.getCurrentFlowElement();
            scopeExecutionEntity.setDeleteReason(deleteReason);
            if (subProcess.hasMultiInstanceLoopCharacteristics()) {
                this.sendProcessInstanceCompletedEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
                commandContext.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
                multiInstanceBehavior.leave(scopeExecutionEntity);
            } else {
                this.sendProcessInstanceCompletedEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
                commandContext.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                ExecutionEntity outgoingFlowExecution = executionEntityManager.createChildExecution(scopeExecutionEntity.getParent());
                outgoingFlowExecution.setCurrentFlowElement(scopeExecutionEntity.getCurrentFlowElement());
                commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(outgoingFlowExecution, true);
            }
        } else if (scopeExecutionEntity.getParentId() == null && scopeExecutionEntity.getSuperExecutionId() != null) {
            ExecutionEntity callActivityExecution = scopeExecutionEntity.getSuperExecution();
            CallActivity callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement();
            SubProcessActivityBehavior subProcessActivityBehavior = null;
            subProcessActivityBehavior = (SubProcessActivityBehavior)callActivity.getBehavior();
            try {
                subProcessActivityBehavior.completing(callActivityExecution, scopeExecutionEntity);
            }
            catch (RuntimeException e) {
                logger.error("Error while completing sub process of execution {}", (Object)scopeExecutionEntity, (Object)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("Error while completing sub process of execution {}", (Object)scopeExecutionEntity, (Object)e);
                throw new FlowableException("Error while completing sub process of execution " + scopeExecutionEntity, (Throwable)e);
            }
            if (callActivity.hasMultiInstanceLoopCharacteristics()) {
                this.sendProcessInstanceCompletedEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
                MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)callActivity.getBehavior();
                multiInstanceBehavior.leave(callActivityExecution);
                executionEntityManager.deleteProcessInstanceExecutionEntity(scopeExecutionEntity.getId(), execution.getCurrentFlowElement().getId(), "terminate end event", false, false, false);
            } else {
                this.sendProcessInstanceCompletedEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
                executionEntityManager.deleteProcessInstanceExecutionEntity(scopeExecutionEntity.getId(), execution.getCurrentFlowElement().getId(), "terminate end event", false, false, false);
                ExecutionEntity superExecutionEntity = (ExecutionEntity)executionEntityManager.findById(scopeExecutionEntity.getSuperExecutionId());
                commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(superExecutionEntity, true);
            }
        }
    }

    protected void endAllHistoricActivities(String processInstanceId, String deleteReason) {
        if (!Context.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            return;
        }
        List<HistoricActivityInstanceEntity> historicActivityInstances = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByProcessInstanceId(processInstanceId);
        for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
            historicActivityInstance.markEnded(deleteReason);
            ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
            if (config == null || !config.getEventDispatcher().isEnabled()) continue;
            config.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance));
        }
    }

    protected void terminateMultiInstanceRoot(DelegateExecution execution, CommandContext commandContext, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity miRootExecutionEntity = executionEntityManager.findFirstMultiInstanceRoot((ExecutionEntity)execution);
        if (miRootExecutionEntity != null) {
            ExecutionEntity siblingExecution = executionEntityManager.createChildExecution(miRootExecutionEntity.getParent());
            siblingExecution.setCurrentFlowElement(miRootExecutionEntity.getCurrentFlowElement());
            this.deleteExecutionEntities(executionEntityManager, miRootExecutionEntity, miRootExecutionEntity.getCurrentFlowElement(), this.createDeleteReason(miRootExecutionEntity.getActivityId()));
            commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(siblingExecution, true);
        } else {
            this.defaultTerminateEndEventBehaviour(execution, commandContext, executionEntityManager);
        }
    }

    protected void deleteExecutionEntities(ExecutionEntityManager executionEntityManager, ExecutionEntity rootExecutionEntity, FlowElement terminateEndEvent, String deleteReason) {
        List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(rootExecutionEntity);
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            this.sendProcessInstanceCompletedEvent(childExecutions.get(i), terminateEndEvent);
            executionEntityManager.deleteExecutionAndRelatedData(childExecutions.get(i), deleteReason, false);
        }
        this.sendProcessInstanceCompletedEvent(rootExecutionEntity, terminateEndEvent);
        executionEntityManager.deleteExecutionAndRelatedData(rootExecutionEntity, deleteReason, false);
    }

    protected void sendProcessInstanceCompletedEvent(ExecutionEntity execution, FlowElement terminateEndEvent) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (execution.isProcessInstanceType() && execution.getSuperExecutionId() == null || execution.getParentId() == null && execution.getSuperExecutionId() != null)) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createTerminateEvent(execution, terminateEndEvent));
        }
        this.dispatchExecutionCancelled(execution, terminateEndEvent);
    }

    protected void dispatchExecutionCancelled(ExecutionEntity execution, FlowElement terminateEndEvent) {
        FlowElement currentFlowElement;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        for (ExecutionEntity subExecution : executionEntityManager.findChildExecutionsByParentExecutionId(execution.getId())) {
            this.dispatchExecutionCancelled(subExecution, terminateEndEvent);
        }
        ExecutionEntity subProcessInstance = Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, terminateEndEvent);
        }
        if ((currentFlowElement = execution.getCurrentFlowElement()) instanceof FlowNode) {
            this.dispatchActivityCancelled(execution, terminateEndEvent);
        }
    }

    protected void dispatchActivityCancelled(DelegateExecution execution, FlowElement terminateEndEvent) {
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.parseActivityType((FlowNode)execution.getCurrentFlowElement()), terminateEndEvent));
    }

    protected String createDeleteReason(String activityId) {
        return "terminate end event (" + activityId + ")";
    }

    public boolean isTerminateAll() {
        return this.terminateAll;
    }

    public void setTerminateAll(boolean terminateAll) {
        this.terminateAll = terminateAll;
    }

    public boolean isTerminateMultiInstance() {
        return this.terminateMultiInstance;
    }

    public void setTerminateMultiInstance(boolean terminateMultiInstance) {
        this.terminateMultiInstance = terminateMultiInstance;
    }
}

