/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.drools.KnowledgeBase;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.AgendaFilter;
import org.flowable.engine.delegate.BusinessRuleTaskDelegate;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.rules.RulesAgendaFilter;
import org.flowable.engine.impl.rules.RulesHelper;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class BusinessRuleTaskActivityBehavior
extends TaskActivityBehavior
implements BusinessRuleTaskDelegate {
    private static final long serialVersionUID = 1L;
    protected Set<Expression> variablesInputExpressions = new HashSet<Expression>();
    protected Set<Expression> rulesExpressions = new HashSet<Expression>();
    protected boolean exclude;
    protected String resultVariable;

    @Override
    public void execute(DelegateExecution execution) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(execution.getProcessDefinitionId());
        String deploymentId = processDefinition.getDeploymentId();
        KnowledgeBase knowledgeBase = RulesHelper.findKnowledgeBaseByDeploymentId(deploymentId);
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        if (this.variablesInputExpressions != null) {
            for (Expression variable : this.variablesInputExpressions) {
                ksession.insert(variable.getValue(execution));
            }
        }
        if (!this.rulesExpressions.isEmpty()) {
            RulesAgendaFilter filter = new RulesAgendaFilter();
            for (Expression ruleName : this.rulesExpressions) {
                filter.addSuffic(ruleName.getValue(execution).toString());
            }
            filter.setAccept(!this.exclude);
            ksession.fireAllRules((AgendaFilter)filter);
        } else {
            ksession.fireAllRules();
        }
        Collection ruleOutputObjects = ksession.getObjects();
        if (ruleOutputObjects != null && !ruleOutputObjects.isEmpty()) {
            ArrayList outputVariables = new ArrayList();
            outputVariables.addAll(ruleOutputObjects);
            execution.setVariable(this.resultVariable, outputVariables);
        }
        ksession.dispose();
        this.leave(execution);
    }

    @Override
    public void addRuleVariableInputIdExpression(Expression inputId) {
        this.variablesInputExpressions.add(inputId);
    }

    @Override
    public void addRuleIdExpression(Expression inputId) {
        this.rulesExpressions.add(inputId);
    }

    @Override
    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    @Override
    public void setResultVariable(String resultVariableName) {
        this.resultVariable = resultVariableName;
    }
}

