/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.util.List;
import org.flowable.engine.history.HistoricDetail;
import org.flowable.engine.history.HistoricDetailQuery;
import org.flowable.engine.impl.AbstractQuery;
import org.flowable.engine.impl.HistoricDetailQueryProperty;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.flowable.engine.impl.variable.HistoricJPAEntityListVariableType;
import org.flowable.engine.impl.variable.HistoricJPAEntityVariableType;
import org.flowable.engine.impl.variable.JPAEntityListVariableType;
import org.flowable.engine.impl.variable.JPAEntityVariableType;

public class HistoricDetailQueryImpl
extends AbstractQuery<HistoricDetailQuery, HistoricDetail>
implements HistoricDetailQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String taskId;
    protected String processInstanceId;
    protected String executionId;
    protected String activityId;
    protected String activityInstanceId;
    protected String type;
    protected boolean excludeTaskRelated;

    public HistoricDetailQueryImpl() {
    }

    public HistoricDetailQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricDetailQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricDetailQueryImpl id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public HistoricDetailQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricDetailQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public HistoricDetailQueryImpl activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public HistoricDetailQueryImpl activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Override
    public HistoricDetailQueryImpl taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Override
    public HistoricDetailQueryImpl formProperties() {
        this.type = "FormProperty";
        return this;
    }

    @Override
    public HistoricDetailQueryImpl variableUpdates() {
        this.type = "VariableUpdate";
        return this;
    }

    @Override
    public HistoricDetailQueryImpl excludeTaskDetails() {
        this.excludeTaskRelated = true;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricDetailEntityManager().findHistoricDetailCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricDetail> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        List<HistoricDetail> historicDetails = commandContext.getHistoricDetailEntityManager().findHistoricDetailsByQueryCriteria(this);
        HistoricDetailVariableInstanceUpdateEntity varUpdate = null;
        if (historicDetails != null) {
            for (HistoricDetail historicDetail : historicDetails) {
                if (!(historicDetail instanceof HistoricDetailVariableInstanceUpdateEntity)) continue;
                varUpdate = (HistoricDetailVariableInstanceUpdateEntity)historicDetail;
                varUpdate.getBytes();
                if (varUpdate.getVariableType() instanceof JPAEntityVariableType) {
                    varUpdate.setVariableType(HistoricJPAEntityVariableType.getSharedInstance());
                    varUpdate.getValue();
                    continue;
                }
                if (!(varUpdate.getVariableType() instanceof JPAEntityListVariableType)) continue;
                varUpdate.setVariableType(HistoricJPAEntityListVariableType.getSharedInstance());
                varUpdate.getValue();
            }
        }
        return historicDetails;
    }

    @Override
    public HistoricDetailQueryImpl orderByProcessInstanceId() {
        this.orderBy(HistoricDetailQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricDetailQueryImpl orderByTime() {
        this.orderBy(HistoricDetailQueryProperty.TIME);
        return this;
    }

    @Override
    public HistoricDetailQueryImpl orderByVariableName() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public HistoricDetailQueryImpl orderByFormPropertyId() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_NAME);
        return this;
    }

    @Override
    public HistoricDetailQueryImpl orderByVariableRevision() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_REVISION);
        return this;
    }

    @Override
    public HistoricDetailQueryImpl orderByVariableType() {
        this.orderBy(HistoricDetailQueryProperty.VARIABLE_TYPE);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getType() {
        return this.type;
    }

    public boolean getExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }
}

