/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.db.BulkDeleteOperation;
import org.flowable.engine.impl.db.DbSqlSession;
import org.flowable.engine.impl.db.DbSqlSessionFactory;
import org.flowable.engine.impl.persistence.cache.EntityCache;
import org.flowable.engine.test.profiler.CommandExecutionResult;
import org.flowable.engine.test.profiler.FlowableProfiler;
import org.flowable.engine.test.profiler.ProfileSession;

public class ProfilingDbSqlSession
extends DbSqlSession {
    protected CommandExecutionResult commandExecutionResult;

    public ProfilingDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache) {
        super(dbSqlSessionFactory, entityCache);
    }

    public ProfilingDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache, Connection connection, String catalog, String schema) {
        super(dbSqlSessionFactory, entityCache, connection, catalog, schema);
    }

    @Override
    public void flush() {
        long startTime = System.currentTimeMillis();
        super.flush();
        long endTime = System.currentTimeMillis();
        CommandExecutionResult commandExecutionResult = this.getCurrentCommandExecution();
        if (commandExecutionResult != null) {
            commandExecutionResult.addDatabaseTime(endTime - startTime);
        }
    }

    @Override
    public void commit() {
        long startTime = System.currentTimeMillis();
        super.commit();
        long endTime = System.currentTimeMillis();
        CommandExecutionResult commandExecutionResult = this.getCurrentCommandExecution();
        if (commandExecutionResult != null) {
            commandExecutionResult.addDatabaseTime(endTime - startTime);
        }
    }

    @Override
    public Object selectOne(String statement, Object parameter) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect(statement);
        }
        return super.selectOne(statement, parameter);
    }

    @Override
    public <T extends Entity> T selectById(Class<T> entityClass, String id, boolean useCache) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect("selectById " + entityClass.getName());
        }
        return super.selectById(entityClass, id, useCache);
    }

    @Override
    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults, boolean useCache) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect(statement);
        }
        return super.selectListWithRawParameter(statement, parameter, firstResult, maxResults, useCache);
    }

    @Override
    public List selectListWithRawParameterWithoutFilter(String statement, Object parameter, int firstResult, int maxResults) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect(statement);
        }
        return super.selectListWithRawParameterWithoutFilter(statement, parameter, firstResult, maxResults);
    }

    @Override
    protected void flushRegularInsert(Entity entity, Class<? extends Entity> clazz) {
        super.flushRegularInsert(entity, clazz);
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbInsert(clazz.getName());
        }
    }

    @Override
    protected void flushBulkInsert(Collection<Entity> entities, Class<? extends Entity> clazz) {
        if (this.getCurrentCommandExecution() != null && entities.size() > 0) {
            this.getCurrentCommandExecution().addDbInsert(clazz.getName() + "-bulk-with-" + entities.size());
        }
        super.flushBulkInsert(entities, clazz);
    }

    @Override
    protected void flushUpdates() {
        if (this.getCurrentCommandExecution() != null) {
            for (Entity persistentObject : this.updatedObjects) {
                this.getCurrentCommandExecution().addDbUpdate(persistentObject.getClass().getName());
            }
        }
        super.flushUpdates();
    }

    @Override
    protected void flushDeleteEntities(Class<? extends Entity> entityClass, Collection<Entity> entitiesToDelete) {
        super.flushDeleteEntities(entityClass, entitiesToDelete);
        if (this.getCurrentCommandExecution() != null) {
            for (Entity entity : entitiesToDelete) {
                this.getCurrentCommandExecution().addDbDelete(entity.getClass().getName());
            }
        }
    }

    @Override
    protected void flushBulkDeletes(Class<? extends Entity> entityClass) {
        if (this.getCurrentCommandExecution() != null && this.bulkDeleteOperations.containsKey(entityClass)) {
            for (BulkDeleteOperation bulkDeleteOperation : (List)this.bulkDeleteOperations.get(entityClass)) {
                this.getCurrentCommandExecution().addDbDelete("Bulk-delete-" + bulkDeleteOperation.getClass());
            }
        }
        super.flushBulkDeletes(entityClass);
    }

    public CommandExecutionResult getCurrentCommandExecution() {
        ProfileSession profileSession;
        if (this.commandExecutionResult == null && (profileSession = FlowableProfiler.getInstance().getCurrentProfileSession()) != null) {
            this.commandExecutionResult = profileSession.getCurrentCommandExecution();
        }
        return this.commandExecutionResult;
    }
}

