/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.scripting;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.Condition;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.scripting.ScriptingEngines;

public class ScriptCondition
implements Condition {
    private final String expression;
    private final String language;

    public ScriptCondition(String expression, String language) {
        this.expression = expression;
        this.language = language;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        Object result = scriptingEngines.evaluate(this.expression, this.language, execution);
        if (result == null) {
            throw new FlowableException("condition script returns null: " + this.expression);
        }
        if (!(result instanceof Boolean)) {
            throw new FlowableException("condition script returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }
}

