/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.SuspendedJobQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.AbstractJobEntity;
import org.flowable.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.engine.impl.persistence.entity.SuspendedJobEntityManager;
import org.flowable.engine.impl.persistence.entity.data.SuspendedJobDataManager;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendedJobEntityManagerImpl
extends AbstractEntityManager<SuspendedJobEntity>
implements SuspendedJobEntityManager {
    private static final Logger logger = LoggerFactory.getLogger(SuspendedJobEntityManagerImpl.class);
    protected SuspendedJobDataManager jobDataManager;

    public SuspendedJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, SuspendedJobDataManager jobDataManager) {
        super(processEngineConfiguration);
        this.jobDataManager = jobDataManager;
    }

    @Override
    public List<SuspendedJobEntity> findJobsByExecutionId(String id) {
        return this.jobDataManager.findJobsByExecutionId(id);
    }

    @Override
    public List<SuspendedJobEntity> findJobsByProcessInstanceId(String id) {
        return this.jobDataManager.findJobsByProcessInstanceId(id);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(SuspendedJobQueryImpl jobQuery, Page page) {
        return this.jobDataManager.findJobsByQueryCriteria(jobQuery, page);
    }

    @Override
    public long findJobCountByQueryCriteria(SuspendedJobQueryImpl jobQuery) {
        return this.jobDataManager.findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.jobDataManager.updateJobTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public void insert(SuspendedJobEntity jobEntity, boolean fireCreateEvent) {
        if (jobEntity.getExecutionId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
            if (execution.getTenantId() != null) {
                jobEntity.setTenantId(execution.getTenantId());
            }
            if (this.isExecutionRelatedEntityCountEnabled(execution)) {
                CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
                countingExecutionEntity.setSuspendedJobCount(countingExecutionEntity.getSuspendedJobCount() + 1);
            }
        }
        super.insert(jobEntity, fireCreateEvent);
    }

    @Override
    public void insert(SuspendedJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    @Override
    public void delete(SuspendedJobEntity jobEntity) {
        CountingExecutionEntity executionEntity;
        super.delete(jobEntity);
        this.deleteExceptionByteArrayRef(jobEntity);
        if (jobEntity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId()))) {
            executionEntity.setSuspendedJobCount(executionEntity.getSuspendedJobCount() - 1);
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, this));
        }
    }

    protected void deleteExceptionByteArrayRef(SuspendedJobEntity jobEntity) {
        ByteArrayRef exceptionByteArrayRef = jobEntity.getExceptionByteArrayRef();
        if (exceptionByteArrayRef != null) {
            exceptionByteArrayRef.delete();
        }
    }

    protected SuspendedJobEntity createSuspendedJob(AbstractJobEntity job) {
        SuspendedJobEntity newSuspendedJobEntity = (SuspendedJobEntity)this.create();
        newSuspendedJobEntity.setJobHandlerConfiguration(job.getJobHandlerConfiguration());
        newSuspendedJobEntity.setJobHandlerType(job.getJobHandlerType());
        newSuspendedJobEntity.setExclusive(job.isExclusive());
        newSuspendedJobEntity.setRepeat(job.getRepeat());
        newSuspendedJobEntity.setRetries(job.getRetries());
        newSuspendedJobEntity.setEndDate(job.getEndDate());
        newSuspendedJobEntity.setExecutionId(job.getExecutionId());
        newSuspendedJobEntity.setProcessInstanceId(job.getProcessInstanceId());
        newSuspendedJobEntity.setProcessDefinitionId(job.getProcessDefinitionId());
        newSuspendedJobEntity.setTenantId(job.getTenantId());
        newSuspendedJobEntity.setJobType(job.getJobType());
        return newSuspendedJobEntity;
    }

    protected SuspendedJobDataManager getDataManager() {
        return this.jobDataManager;
    }

    public void setJobDataManager(SuspendedJobDataManager jobDataManager) {
        this.jobDataManager = jobDataManager;
    }
}

