/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.HistoricProcessInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.data.HistoricProcessInstanceDataManager;

public class HistoricProcessInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricProcessInstanceEntity>
implements HistoricProcessInstanceEntityManager {
    protected HistoricProcessInstanceDataManager historicProcessInstanceDataManager;

    public HistoricProcessInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, HistoricProcessInstanceDataManager historicProcessInstanceDataManager) {
        super(processEngineConfiguration);
        this.historicProcessInstanceDataManager = historicProcessInstanceDataManager;
    }

    @Override
    protected DataManager<HistoricProcessInstanceEntity> getDataManager() {
        return this.historicProcessInstanceDataManager;
    }

    @Override
    public HistoricProcessInstanceEntity create(ExecutionEntity processInstanceExecutionEntity) {
        return this.historicProcessInstanceDataManager.create(processInstanceExecutionEntity);
    }

    @Override
    public void deleteHistoricProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            List<String> historicProcessInstanceIds = this.historicProcessInstanceDataManager.findHistoricProcessInstanceIdsByProcessDefinitionId(processDefinitionId);
            for (String historicProcessInstanceId : historicProcessInstanceIds) {
                this.delete(historicProcessInstanceId);
            }
        }
    }

    @Override
    public void delete(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.findById(historicProcessInstanceId);
            this.getHistoricDetailEntityManager().deleteHistoricDetailsByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstanceByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstancesByProcessInstanceId(historicProcessInstanceId);
            this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByProcInstance(historicProcessInstanceId);
            this.getCommentEntityManager().deleteCommentsByProcessInstanceId(historicProcessInstanceId);
            this.delete(historicProcessInstance, false);
            List<HistoricProcessInstanceEntity> selectList = this.historicProcessInstanceDataManager.findHistoricProcessInstancesBySuperProcessInstanceId(historicProcessInstanceId);
            for (HistoricProcessInstanceEntity child : selectList) {
                this.delete(child.getId());
            }
        }
    }

    @Override
    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicProcessInstanceDataManager.findHistoricProcessInstanceCountByQueryCriteria(historicProcessInstanceQuery);
        }
        return 0L;
    }

    @Override
    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicProcessInstanceDataManager.findHistoricProcessInstancesByQueryCriteria(historicProcessInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<HistoricProcessInstance> findHistoricProcessInstancesAndVariablesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicProcessInstanceDataManager.findHistoricProcessInstancesAndVariablesByQueryCriteria(historicProcessInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.historicProcessInstanceDataManager.findHistoricProcessInstancesByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.historicProcessInstanceDataManager.findHistoricProcessInstanceCountByNativeQuery(parameterMap);
    }

    public HistoricProcessInstanceDataManager getHistoricProcessInstanceDataManager() {
        return this.historicProcessInstanceDataManager;
    }

    public void setHistoricProcessInstanceDataManager(HistoricProcessInstanceDataManager historicProcessInstanceDataManager) {
        this.historicProcessInstanceDataManager = historicProcessInstanceDataManager;
    }
}

