/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.interceptor;

import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandInvoker;
import org.flowable.engine.runtime.Debugger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugCommandInvoker
extends CommandInvoker {
    private static final Logger logger = LoggerFactory.getLogger(DebugCommandInvoker.class);
    private final Debugger debugger;

    public DebugCommandInvoker(Debugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public void executeOperations(CommandContext commandContext) {
        while (!commandContext.getAgenda().isEmpty()) {
            Runnable runnable = commandContext.getAgenda().peekOperation();
            if (!this.debugger.isBreakPoint(runnable)) {
                this.executeOperation(commandContext.getAgenda().getNextOperation());
                continue;
            }
            logger.debug("Runnable {} was identified as a break point. Stopping operation execution.", (Object)runnable);
            this.debugger.breakOperationExecution(commandContext);
        }
    }
}

