/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.form;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.bpmn.model.FormValue;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.form.AbstractFormType;
import org.flowable.engine.impl.form.DateFormType;
import org.flowable.engine.impl.form.EnumFormType;

public class FormTypes {
    protected Map<String, AbstractFormType> formTypes = new HashMap<String, AbstractFormType>();

    public void addFormType(AbstractFormType formType) {
        this.formTypes.put(formType.getName(), formType);
    }

    public AbstractFormType parseFormPropertyType(FormProperty formProperty) {
        AbstractFormType formType = null;
        if ("date".equals(formProperty.getType()) && StringUtils.isNotEmpty((CharSequence)formProperty.getDatePattern())) {
            formType = new DateFormType(formProperty.getDatePattern());
        } else if ("enum".equals(formProperty.getType())) {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            for (FormValue formValue : formProperty.getFormValues()) {
                values.put(formValue.getId(), formValue.getName());
            }
            formType = new EnumFormType(values);
        } else if (StringUtils.isNotEmpty((CharSequence)formProperty.getType()) && (formType = this.formTypes.get(formProperty.getType())) == null) {
            throw new FlowableIllegalArgumentException("unknown type '" + formProperty.getType() + "' " + formProperty.getId());
        }
        return formType;
    }
}

