/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.el;

import de.odysseus.el.ExpressionFactoryImpl;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ValueExpression;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.VariableScope;
import org.flowable.engine.impl.bpmn.data.ItemInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.el.DynamicBeanPropertyELResolver;
import org.flowable.engine.impl.el.FlowableElContext;
import org.flowable.engine.impl.el.JsonNodeELResolver;
import org.flowable.engine.impl.el.JuelExpression;
import org.flowable.engine.impl.el.ParsingElContext;
import org.flowable.engine.impl.el.ReadOnlyMapELResolver;
import org.flowable.engine.impl.el.VariableScopeElResolver;
import org.flowable.engine.impl.persistence.entity.VariableScopeImpl;

public class ExpressionManager {
    protected ExpressionFactory expressionFactory = new ExpressionFactoryImpl();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ELContext parsingElContext;
    protected Map<Object, Object> beans;

    public ExpressionManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this(null, processEngineConfiguration);
    }

    public ExpressionManager(ProcessEngineConfigurationImpl processEngineConfiguration, boolean initFactory) {
        this(null, processEngineConfiguration, false);
    }

    public ExpressionManager(Map<Object, Object> beans, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this(beans, processEngineConfiguration, true);
    }

    public ExpressionManager(Map<Object, Object> beans, ProcessEngineConfigurationImpl processEngineConfiguration, boolean initFactory) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.beans = beans;
        this.parsingElContext = new ParsingElContext(processEngineConfiguration);
    }

    public Expression createExpression(String expression) {
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return new JuelExpression(valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public ELContext getElContext(VariableScope variableScope) {
        ELContext elContext = null;
        if (variableScope instanceof VariableScopeImpl) {
            VariableScopeImpl variableScopeImpl = (VariableScopeImpl)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof VariableScopeImpl) {
                ((VariableScopeImpl)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    protected FlowableElContext createElContext(VariableScope variableScope) {
        ELResolver elResolver = this.createElResolver(variableScope);
        return new FlowableElContext(elResolver, this.processEngineConfiguration);
    }

    protected ELResolver createElResolver(VariableScope variableScope) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new VariableScopeElResolver(variableScope));
        if (this.beans != null) {
            elResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new JsonNodeELResolver());
        elResolver.add((ELResolver)new DynamicBeanPropertyELResolver(ItemInstance.class, "getFieldValue", "setFieldValue"));
        elResolver.add((ELResolver)new BeanELResolver());
        return elResolver;
    }

    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }
}

