/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.task.Task;

public class GetTaskVariableCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String variableName;
    protected boolean isLocal;

    public GetTaskVariableCmd(String taskId, String variableName, boolean isLocal) {
        this.taskId = taskId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        Object value = this.isLocal ? task.getVariableLocal(this.variableName, false) : task.getVariable(this.variableName, false);
        return value;
    }
}

