/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.engine.FlowableTaskAlreadyClaimedException;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.Flowable5Util;

public class ClaimTaskCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public ClaimTaskCmd(String taskId, String userId) {
        super(taskId);
        this.userId = userId;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.claimTask(this.taskId, this.userId);
            return null;
        }
        if (this.userId != null) {
            task.setClaimTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            if (task.getAssignee() != null) {
                if (!task.getAssignee().equals(this.userId)) {
                    throw new FlowableTaskAlreadyClaimedException(task.getId(), task.getAssignee());
                }
            } else {
                commandContext.getTaskEntityManager().changeTaskAssignee(task, this.userId);
            }
        } else {
            task.setClaimTime(null);
            commandContext.getTaskEntityManager().changeTaskAssignee(task, null);
        }
        commandContext.getHistoryManager().recordTaskClaim(task);
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot claim a suspended task";
    }
}

