/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.impl.asyncexecutor.AcquiredJobEntities;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.JobEntity;

public class AcquireJobsCmd
implements Command<AcquiredJobEntities> {
    private final AsyncExecutor asyncExecutor;
    private final int remainingCapacity;

    public AcquireJobsCmd(AsyncExecutor asyncExecutor) {
        this(asyncExecutor, Integer.MAX_VALUE);
    }

    public AcquireJobsCmd(AsyncExecutor asyncExecutor, int remainingCapacity) {
        this.asyncExecutor = asyncExecutor;
        this.remainingCapacity = remainingCapacity;
    }

    @Override
    public AcquiredJobEntities execute(CommandContext commandContext) {
        int maxResults = Math.min(this.remainingCapacity, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
        List<JobEntity> jobs = commandContext.getJobEntityManager().findJobsToExecute(new Page(0, maxResults));
        AcquiredJobEntities acquiredJobs = new AcquiredJobEntities();
        for (JobEntity job : jobs) {
            this.lockJob(commandContext, job, this.asyncExecutor.getAsyncJobLockTimeInMillis());
            acquiredJobs.addJob(job);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, JobEntity job, int lockTimeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockOwner(this.asyncExecutor.getLockOwner());
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

