/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg;

import javax.sql.DataSource;
import org.apache.ibatis.transaction.TransactionFactory;
import org.flowable.engine.cfg.AbstractProcessEngineConfigurator;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.transaction.TransactionContextAwareDataSource;
import org.flowable.engine.common.impl.transaction.TransactionContextAwareTransactionFactory;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.cfg.StandaloneIdmEngineConfiguration;
import org.flowable.idm.engine.impl.cfg.TransactionContext;

public class IdmEngineConfigurator
extends AbstractProcessEngineConfigurator {
    protected IdmEngineConfiguration idmEngineConfiguration;

    @Override
    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.idmEngineConfiguration == null) {
            this.idmEngineConfiguration = new StandaloneIdmEngineConfiguration();
            if (processEngineConfiguration.getDataSource() != null) {
                DataSource originalDatasource = processEngineConfiguration.getDataSource();
                if (processEngineConfiguration.isTransactionsExternallyManaged()) {
                    this.idmEngineConfiguration.setDataSource(originalDatasource);
                } else {
                    this.idmEngineConfiguration.setDataSource((DataSource)new TransactionContextAwareDataSource(originalDatasource));
                }
            } else {
                throw new FlowableException("A datasource is required for initializing the IDM engine ");
            }
            this.idmEngineConfiguration.setDatabaseCatalog(processEngineConfiguration.getDatabaseCatalog());
            this.idmEngineConfiguration.setDatabaseSchema(processEngineConfiguration.getDatabaseSchema());
            this.idmEngineConfiguration.setDatabaseSchemaUpdate(processEngineConfiguration.getDatabaseSchemaUpdate());
            this.idmEngineConfiguration.setDatabaseTablePrefix(processEngineConfiguration.getDatabaseTablePrefix());
            this.idmEngineConfiguration.setDatabaseWildcardEscapeCharacter(processEngineConfiguration.getDatabaseWildcardEscapeCharacter());
            if (processEngineConfiguration.isTransactionsExternallyManaged()) {
                this.idmEngineConfiguration.setTransactionsExternallyManaged(true);
            } else {
                this.idmEngineConfiguration.setTransactionFactory((TransactionFactory)new TransactionContextAwareTransactionFactory(TransactionContext.class));
            }
            if (processEngineConfiguration.getEventDispatcher() != null) {
                this.idmEngineConfiguration.setEventDispatcher(processEngineConfiguration.getEventDispatcher());
            }
        }
        IdmEngine idmEngine = this.idmEngineConfiguration.buildIdmEngine();
        processEngineConfiguration.setIdmEngineInitialized(true);
        processEngineConfiguration.setIdmIdentityService(idmEngine.getIdmIdentityService());
    }

    @Override
    public void beforeInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    public IdmEngineConfiguration getIdmEngineConfiguration() {
        return this.idmEngineConfiguration;
    }

    public IdmEngineConfigurator setIdmEngineConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
        this.idmEngineConfiguration = idmEngineConfiguration;
        return this;
    }
}

