/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.Task;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.CustomPropertiesResolver;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.DelegateTask;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.delegate.TransactionDependentExecutionListener;
import org.flowable.engine.delegate.TransactionDependentTaskListener;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.delegate.invocation.ExecutionListenerInvocation;
import org.flowable.engine.impl.delegate.invocation.TaskListenerInvocation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.ReflectUtil;

public class ClassDelegate
extends AbstractBpmnActivityBehavior
implements TaskListener,
ExecutionListener,
TransactionDependentExecutionListener,
TransactionDependentTaskListener,
SubProcessActivityBehavior,
CustomPropertiesResolver {
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;
    protected ExecutionListener executionListenerInstance;
    protected TransactionDependentExecutionListener transactionDependentExecutionListenerInstance;
    protected TaskListener taskListenerInstance;
    protected TransactionDependentTaskListener transactionDependentTaskListenerInstance;
    protected ActivityBehavior activityBehaviorInstance;
    protected Expression skipExpression;
    protected List<MapExceptionEntry> mapExceptions;
    protected CustomPropertiesResolver customPropertiesResolverInstance;

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
        this.skipExpression = skipExpression;
    }

    public ClassDelegate(String id, String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression, List<MapExceptionEntry> mapExceptions) {
        this(className, fieldDeclarations, skipExpression);
        this.serviceTaskId = id;
        this.mapExceptions = mapExceptions;
    }

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        this(className, fieldDeclarations, null);
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations, null);
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this(clazz.getName(), fieldDeclarations, skipExpression);
    }

    @Override
    public void notify(DelegateExecution execution) {
        if (this.executionListenerInstance == null) {
            this.executionListenerInstance = this.getExecutionListenerInstance();
        }
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(this.executionListenerInstance, execution));
    }

    @Override
    public void notify(String processInstanceId, String executionId, FlowElement flowElement, Map<String, Object> executionVariables, Map<String, Object> customPropertiesMap) {
        if (this.transactionDependentExecutionListenerInstance == null) {
            this.transactionDependentExecutionListenerInstance = this.getTransactionDependentExecutionListenerInstance();
        }
        this.transactionDependentExecutionListenerInstance.notify(processInstanceId, executionId, flowElement, executionVariables, customPropertiesMap);
    }

    @Override
    public Map<String, Object> getCustomPropertiesMap(DelegateExecution execution) {
        if (this.customPropertiesResolverInstance == null) {
            this.customPropertiesResolverInstance = this.getCustomPropertiesResolverInstance();
        }
        return this.customPropertiesResolverInstance.getCustomPropertiesMap(execution);
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        if (this.taskListenerInstance == null) {
            this.taskListenerInstance = this.getTaskListenerInstance();
        }
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(this.taskListenerInstance, delegateTask));
        }
        catch (Exception e) {
            throw new FlowableException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void notify(String processInstanceId, String executionId, Task task, Map<String, Object> executionVariables, Map<String, Object> customPropertiesMap) {
        if (this.transactionDependentTaskListenerInstance == null) {
            this.transactionDependentTaskListenerInstance = this.getTransactionDependentTaskListenerInstance();
        }
        this.transactionDependentTaskListenerInstance.notify(processInstanceId, executionId, task, executionVariables, customPropertiesMap);
    }

    protected ExecutionListener getExecutionListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ExecutionListener) {
            return (ExecutionListener)delegateInstance;
        }
        if (delegateInstance instanceof JavaDelegate) {
            return new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance);
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + ExecutionListener.class + " nor " + JavaDelegate.class);
    }

    protected TransactionDependentExecutionListener getTransactionDependentExecutionListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TransactionDependentExecutionListener) {
            return (TransactionDependentExecutionListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TransactionDependentExecutionListener.class);
    }

    protected CustomPropertiesResolver getCustomPropertiesResolverInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof CustomPropertiesResolver) {
            return (CustomPropertiesResolver)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + CustomPropertiesResolver.class);
    }

    protected TaskListener getTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TaskListener) {
            return (TaskListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TaskListener.class);
    }

    protected TransactionDependentTaskListener getTransactionDependentTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TransactionDependentTaskListener) {
            return (TransactionDependentTaskListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TransactionDependentTaskListener.class);
    }

    @Override
    public void execute(DelegateExecution execution) {
        block6: {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                String overrideClassName;
                ObjectNode taskElementProperties;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskClassName") && StringUtils.isNotEmpty((CharSequence)(overrideClassName = taskElementProperties.get("serviceTaskClassName").asText())) && !overrideClassName.equals(this.className)) {
                    this.className = overrideClassName;
                    this.activityBehaviorInstance = null;
                }
                if (this.activityBehaviorInstance == null) {
                    this.activityBehaviorInstance = this.getActivityBehaviorInstance();
                }
                try {
                    this.activityBehaviorInstance.execute(execution);
                }
                catch (BpmnError error) {
                    ErrorPropagation.propagateError(error, execution);
                }
                catch (RuntimeException e) {
                    if (ErrorPropagation.mapException(e, (ExecutionEntity)execution, this.mapExceptions)) break block6;
                    throw e;
                }
            }
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance();
        }
        if (!(this.activityBehaviorInstance instanceof TriggerableActivityBehavior)) {
            throw new FlowableException("signal() can only be called on a " + TriggerableActivityBehavior.class.getName() + " instance");
        }
        ((TriggerableActivityBehavior)this.activityBehaviorInstance).trigger(execution, signalName, signalData);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance();
        }
        if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
            throw new FlowableException("completing() can only be called on a " + SubProcessActivityBehavior.class.getName() + " instance");
        }
        ((SubProcessActivityBehavior)this.activityBehaviorInstance).completing(execution, subProcessInstance);
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance();
        }
        if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
            throw new FlowableException("completed() can only be called on a " + SubProcessActivityBehavior.class.getName() + " instance");
        }
        ((SubProcessActivityBehavior)this.activityBehaviorInstance).completed(execution);
    }

    protected ActivityBehavior getActivityBehaviorInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return this.determineBehaviour((ActivityBehavior)delegateInstance);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return this.determineBehaviour(new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance));
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }

    protected ActivityBehavior determineBehaviour(ActivityBehavior delegateInstance) {
        if (this.hasMultiInstanceCharacteristics()) {
            this.multiInstanceActivityBehavior.setInnerActivityBehavior((AbstractBpmnActivityBehavior)delegateInstance);
            return this.multiInstanceActivityBehavior;
        }
        return delegateInstance;
    }

    protected Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.defaultInstantiateDelegate(className, fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.defaultInstantiateDelegate(clazz.getName(), fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        Object object = ReflectUtil.instantiate(className);
        ClassDelegate.applyFieldDeclaration(fieldDeclarations, object);
        return object;
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target) {
        ClassDelegate.applyFieldDeclaration(fieldDeclarations, target, true);
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target, boolean throwExceptionOnMissingField) {
        if (fieldDeclarations != null) {
            for (FieldDeclaration declaration : fieldDeclarations) {
                ClassDelegate.applyFieldDeclaration(declaration, target, throwExceptionOnMissingField);
            }
        }
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target) {
        ClassDelegate.applyFieldDeclaration(declaration, target, true);
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target, boolean throwExceptionOnMissingField) {
        Method setterMethod = ReflectUtil.getSetter(declaration.getName(), target.getClass(), declaration.getValue().getClass());
        if (setterMethod != null) {
            try {
                setterMethod.invoke(target, declaration.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new FlowableException("Error while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FlowableException("Illegal access when calling '" + declaration.getName() + "' on class " + target.getClass().getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new FlowableException("Exception while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), (Throwable)e);
            }
        } else {
            Field field = ReflectUtil.getField(declaration.getName(), target);
            if (field == null) {
                if (throwExceptionOnMissingField) {
                    throw new FlowableIllegalArgumentException("Field definition uses unexisting field '" + declaration.getName() + "' on class " + target.getClass().getName());
                }
                return;
            }
            if (!ClassDelegate.fieldTypeCompatible(declaration, field)) {
                throw new FlowableIllegalArgumentException("Incompatible type set on field declaration '" + declaration.getName() + "' for class " + target.getClass().getName() + ". Declared value has type " + declaration.getValue().getClass().getName() + ", while expecting " + field.getType().getName());
            }
            ReflectUtil.setField(field, target, declaration.getValue());
        }
    }

    public static boolean fieldTypeCompatible(FieldDeclaration declaration, Field field) {
        if (declaration.getValue() != null) {
            return field.getType().isAssignableFrom(declaration.getValue().getClass());
        }
        return true;
    }

    public String getClassName() {
        return this.className;
    }
}

