/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public SequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution multiInstanceExecution) {
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceExecution);
        if (nrOfInstances == 0) {
            return nrOfInstances;
        }
        if (nrOfInstances < 0) {
            throw new FlowableIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
        }
        ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceExecution);
        execution.setCurrentFlowElement(multiInstanceExecution.getCurrentFlowElement());
        multiInstanceExecution.setMultiInstanceRoot(true);
        multiInstanceExecution.setActive(false);
        this.setLoopVariable(multiInstanceExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(multiInstanceExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(multiInstanceExecution, "nrOfActiveInstances", 1);
        this.setLoopVariable(multiInstanceExecution, this.getCollectionElementIndexVariable(), 0);
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", 1);
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), 0);
        this.logLoopDetails(multiInstanceExecution, "initialized", 0, 0, 1, nrOfInstances);
        if (nrOfInstances > 0) {
            this.executeOriginalBehavior(execution, 0);
        }
        return nrOfInstances;
    }

    @Override
    public void leave(DelegateExecution execution) {
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int loopCounter = this.getLoopVariable(multiInstanceRootExecution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfCompletedInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable(multiInstanceRootExecution, this.getCollectionElementIndexVariable(), loopCounter);
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), loopCounter);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution, null);
        this.callActivityEndListeners(execution);
        if (loopCounter >= nrOfInstances || this.completionConditionSatisfied(multiInstanceRootExecution)) {
            this.removeLocalLoopVariable(multiInstanceRootExecution, this.getCollectionElementIndexVariable());
            this.removeLocalLoopVariable(execution, this.getCollectionElementIndexVariable());
            multiInstanceRootExecution.setMultiInstanceRoot(false);
            multiInstanceRootExecution.setScope(false);
            multiInstanceRootExecution.setCurrentFlowElement(execution.getCurrentFlowElement());
            Context.getCommandContext().getExecutionEntityManager().deleteChildExecutions((ExecutionEntity)multiInstanceRootExecution, "MI_END", false);
            super.leave(multiInstanceRootExecution);
        } else {
            try {
                if (execution.getCurrentFlowElement() instanceof SubProcess) {
                    ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
                    ExecutionEntity executionToContinue = executionEntityManager.createChildExecution((ExecutionEntity)multiInstanceRootExecution);
                    executionToContinue.setCurrentFlowElement(execution.getCurrentFlowElement());
                    executionToContinue.setScope(true);
                    this.setLoopVariable(executionToContinue, "nrOfInstances", nrOfInstances);
                    this.setLoopVariable(executionToContinue, "nrOfCompletedInstances", nrOfCompletedInstances);
                    this.setLoopVariable(executionToContinue, "nrOfActiveInstances", nrOfActiveInstances);
                    this.setLoopVariable(executionToContinue, this.getCollectionElementIndexVariable(), loopCounter);
                    this.executeOriginalBehavior(executionToContinue, loopCounter);
                } else {
                    this.executeOriginalBehavior(execution, loopCounter);
                }
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new FlowableException("Could not execute inner activity behavior of multi instance behavior", (Throwable)e);
            }
        }
    }
}

