/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor;

import java.util.LinkedList;
import java.util.UUID;
import org.flowable.engine.impl.asyncexecutor.AcquireAsyncJobsDueRunnable;
import org.flowable.engine.impl.asyncexecutor.AcquireTimerJobsRunnable;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.flowable.engine.impl.asyncexecutor.ExecuteAsyncRunnableFactory;
import org.flowable.engine.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.UnacquireOwnedJobsCmd;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncExecutor
implements AsyncExecutor {
    private static Logger log = LoggerFactory.getLogger(AbstractAsyncExecutor.class);
    protected AcquireTimerJobsRunnable timerJobRunnable;
    protected AcquireAsyncJobsDueRunnable asyncJobsDueRunnable;
    protected ResetExpiredJobsRunnable resetExpiredJobsRunnable;
    protected ExecuteAsyncRunnableFactory executeAsyncRunnableFactory;
    protected boolean isAutoActivate;
    protected boolean isActive;
    protected boolean isMessageQueueMode;
    protected int maxTimerJobsPerAcquisition = 1;
    protected int maxAsyncJobsDuePerAcquisition = 1;
    protected int defaultTimerJobAcquireWaitTimeInMillis = 10000;
    protected int defaultAsyncJobAcquireWaitTimeInMillis = 10000;
    protected int defaultQueueSizeFullWaitTime;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int timerLockTimeInMillis = 300000;
    protected int asyncJobLockTimeInMillis = 300000;
    protected int retryWaitTimeInMillis = 500;
    protected int resetExpiredJobsInterval = 60000;
    protected int resetExpiredJobsPageSize = 3;
    protected LinkedList<Job> temporaryJobQueue = new LinkedList();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Override
    public boolean executeAsyncJob(Job job) {
        if (this.isMessageQueueMode) {
            return true;
        }
        Runnable runnable = null;
        if (this.isActive) {
            runnable = this.createRunnableForJob(job);
            return this.executeAsyncJob(job, runnable);
        }
        this.temporaryJobQueue.add(job);
        return true;
    }

    protected abstract boolean executeAsyncJob(Job var1, Runnable var2);

    protected void unlockOwnedJobs() {
        this.processEngineConfiguration.getCommandExecutor().execute(new UnacquireOwnedJobsCmd(this.lockOwner, null));
    }

    protected Runnable createRunnableForJob(Job job) {
        if (this.executeAsyncRunnableFactory == null) {
            return new ExecuteAsyncRunnable(job, this.processEngineConfiguration);
        }
        return this.executeAsyncRunnableFactory.createExecuteAsyncRunnable(job, this.processEngineConfiguration);
    }

    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        log.info("Starting up the async job executor [{}].", (Object)this.getClass().getName());
        this.initializeRunnables();
        this.startAdditionalComponents();
        this.executeTemporaryJobs();
    }

    protected void initializeRunnables() {
        if (this.timerJobRunnable == null) {
            this.timerJobRunnable = new AcquireTimerJobsRunnable(this, this.processEngineConfiguration.getJobManager());
        }
        if (this.resetExpiredJobsRunnable == null) {
            this.resetExpiredJobsRunnable = new ResetExpiredJobsRunnable(this);
        }
        if (!this.isMessageQueueMode && this.asyncJobsDueRunnable == null) {
            this.asyncJobsDueRunnable = new AcquireAsyncJobsDueRunnable(this);
        }
    }

    protected abstract void startAdditionalComponents();

    protected void executeTemporaryJobs() {
        while (!this.temporaryJobQueue.isEmpty()) {
            Job job = this.temporaryJobQueue.pop();
            this.executeAsyncJob(job);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        log.info("Shutting down the async job executor [{}].", (Object)this.getClass().getName());
        this.stopRunnables();
        this.shutdownAdditionalComponents();
        this.isActive = false;
    }

    protected void stopRunnables() {
        if (this.timerJobRunnable != null) {
            this.timerJobRunnable.stop();
        }
        if (this.asyncJobsDueRunnable != null) {
            this.asyncJobsDueRunnable.stop();
        }
        if (this.resetExpiredJobsRunnable != null) {
            this.resetExpiredJobsRunnable.stop();
        }
        this.timerJobRunnable = null;
        this.asyncJobsDueRunnable = null;
        this.resetExpiredJobsRunnable = null;
    }

    protected abstract void shutdownAdditionalComponents();

    @Override
    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    @Override
    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMessageQueueMode() {
        return this.isMessageQueueMode;
    }

    public void setMessageQueueMode(boolean isMessageQueueMode) {
        this.isMessageQueueMode = isMessageQueueMode;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.timerLockTimeInMillis;
    }

    @Override
    public void setTimerLockTimeInMillis(int timerLockTimeInMillis) {
        this.timerLockTimeInMillis = timerLockTimeInMillis;
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.asyncJobLockTimeInMillis;
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int asyncJobLockTimeInMillis) {
        this.asyncJobLockTimeInMillis = asyncJobLockTimeInMillis;
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.maxTimerJobsPerAcquisition;
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxTimerJobsPerAcquisition) {
        this.maxTimerJobsPerAcquisition = maxTimerJobsPerAcquisition;
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxAsyncJobsDuePerAcquisition) {
        this.maxAsyncJobsDuePerAcquisition = maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int defaultTimerJobAcquireWaitTimeInMillis) {
        this.defaultTimerJobAcquireWaitTimeInMillis = defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.defaultAsyncJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int defaultAsyncJobAcquireWaitTimeInMillis) {
        this.defaultAsyncJobAcquireWaitTimeInMillis = defaultAsyncJobAcquireWaitTimeInMillis;
    }

    public void setTimerJobRunnable(AcquireTimerJobsRunnable timerJobRunnable) {
        this.timerJobRunnable = timerJobRunnable;
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.defaultQueueSizeFullWaitTime;
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTime) {
        this.defaultQueueSizeFullWaitTime = defaultQueueSizeFullWaitTime;
    }

    public void setAsyncJobsDueRunnable(AcquireAsyncJobsDueRunnable asyncJobsDueRunnable) {
        this.asyncJobsDueRunnable = asyncJobsDueRunnable;
    }

    public void setResetExpiredJobsRunnable(ResetExpiredJobsRunnable resetExpiredJobsRunnable) {
        this.resetExpiredJobsRunnable = resetExpiredJobsRunnable;
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.retryWaitTimeInMillis;
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        this.retryWaitTimeInMillis = retryWaitTimeInMillis;
    }

    @Override
    public int getResetExpiredJobsInterval() {
        return this.resetExpiredJobsInterval;
    }

    @Override
    public void setResetExpiredJobsInterval(int resetExpiredJobsInterval) {
        this.resetExpiredJobsInterval = resetExpiredJobsInterval;
    }

    @Override
    public int getResetExpiredJobsPageSize() {
        return this.resetExpiredJobsPageSize;
    }

    @Override
    public void setResetExpiredJobsPageSize(int resetExpiredJobsPageSize) {
        this.resetExpiredJobsPageSize = resetExpiredJobsPageSize;
    }

    public ExecuteAsyncRunnableFactory getExecuteAsyncRunnableFactory() {
        return this.executeAsyncRunnableFactory;
    }

    public void setExecuteAsyncRunnableFactory(ExecuteAsyncRunnableFactory executeAsyncRunnableFactory) {
        this.executeAsyncRunnableFactory = executeAsyncRunnableFactory;
    }
}

