/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.persistence;

import java.util.function.Function;
import java.util.function.Supplier;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.common.engine.impl.interceptor.SessionFactory;

public class GenericManagerFactory
implements SessionFactory {
    protected Class<? extends Session> typeClass;
    protected Function<CommandContext, ? extends Session> sessionCreator;

    public GenericManagerFactory(Class<? extends Session> typeClass, Supplier<? extends Session> sessionCreator) {
        this(typeClass, (CommandContext context) -> (Session)sessionCreator.get());
    }

    public GenericManagerFactory(Class<? extends Session> typeClass, Function<CommandContext, ? extends Session> sessionCreator) {
        this.typeClass = typeClass;
        this.sessionCreator = sessionCreator;
    }

    @Deprecated
    public GenericManagerFactory(Class<? extends Session> typeClass, Class<? extends Session> implementationClass) {
        this(typeClass, (CommandContext commandContext) -> {
            try {
                return (Session)implementationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new FlowableException("couldn't instantiate " + implementationClass.getName() + ": " + e.getMessage(), (Throwable)e);
            }
        });
    }

    @Deprecated
    public GenericManagerFactory(Class<? extends Session> implementationClass) {
        this(implementationClass, implementationClass);
    }

    @Override
    public Class<?> getSessionType() {
        return this.typeClass;
    }

    @Override
    public Session openSession(CommandContext commandContext) {
        return this.sessionCreator.apply(commandContext);
    }
}

