/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.rest.service.api.repository.BaseDecisionResource;
import org.flowable.dmn.rest.service.api.repository.DecisionResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Decisions"}, description="Manage Decisions", authorizations={@Authorization(value="basicAuth")})
public class DecisionResource
extends BaseDecisionResource {
    @ApiOperation(value="Get a decision", tags={"Decisions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the decision is returned"), @ApiResponse(code=404, message="Indicates the requested decision was not found.")})
    @GetMapping(value={"/dmn-repository/decisions/{decisionId}"}, produces={"application/json"})
    public DecisionResponse getDecision(@ApiParam(name="decisionId") @PathVariable String decisionId) {
        DmnDecision decision = this.getDecisionFromRequest(decisionId);
        return this.dmnRestResponseFactory.createDecisionResponse(decision);
    }
}

