/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.dmn.api.DmnHistoricDecisionExecution;
import org.flowable.dmn.rest.service.api.history.BaseHistoricDecisionExecutionResource;
import org.flowable.dmn.rest.service.api.history.HistoricDecisionExecutionResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Historic Decision Executions"}, description="Historic Decision Execution", authorizations={@Authorization(value="basicAuth")})
public class HistoricDecisionExecutionResource
extends BaseHistoricDecisionExecutionResource {
    @ApiOperation(value="Get a historic decision execution", tags={"Historic Decision Executions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the historic decision execution is returned"), @ApiResponse(code=404, message="Indicates the requested historic decision execution was not found.")})
    @GetMapping(value={"/dmn-history/historic-decision-executions/{historicDecisionExecutionId}"}, produces={"application/json"})
    public HistoricDecisionExecutionResponse getHistoricDecisionExecution(@ApiParam(name="historicDecisionExecutionId") @PathVariable String historicDecisionExecutionId) {
        DmnHistoricDecisionExecution decisionExecution = this.getHistoricDecisionExecutionFromRequest(historicDecisionExecutionId);
        return this.dmnRestResponseFactory.createHistoryDecisionExecutionResponse(decisionExecution);
    }
}

