/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.api;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.ListProcessor;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.common.rest.api.RequestUtil;

public interface PaginateListUtil {
    public static <RES, REQ> DataResponse<RES> paginateList(Map<String, String> requestParams, Query<?, REQ> query, String defaultSort, Map<String, QueryProperty> properties, ListProcessor<REQ, RES> listProcessor) {
        return PaginateListUtil.paginateList(requestParams, null, query, defaultSort, properties, listProcessor);
    }

    public static <RES, REQ> DataResponse<RES> paginateList(Map<String, String> requestParams, PaginateRequest paginateRequest, Query<?, REQ> query, String defaultSort, Map<String, QueryProperty> properties, ListProcessor<REQ, RES> listProcessor) {
        if (paginateRequest == null) {
            paginateRequest = new PaginateRequest();
        }
        if (paginateRequest.getStart() == null) {
            paginateRequest.setStart(RequestUtil.getInteger(requestParams, "start", 0));
        }
        if (paginateRequest.getSize() == null) {
            paginateRequest.setSize(RequestUtil.getInteger(requestParams, "size", 10));
        }
        if (paginateRequest.getOrder() == null) {
            paginateRequest.setOrder(requestParams.get("order"));
        }
        if (paginateRequest.getSort() == null) {
            paginateRequest.setSort(requestParams.get("sort"));
        }
        return PaginateListUtil.paginateList(paginateRequest, query, defaultSort, properties, listProcessor);
    }

    public static <RES, REQ> DataResponse<RES> paginateList(PaginateRequest paginateRequest, Query<?, REQ> query, String defaultSort, Map<String, QueryProperty> properties, ListProcessor<REQ, RES> listProcessor) {
        String order;
        String sort;
        Integer size;
        Integer start = paginateRequest.getStart();
        if (start == null || start < 0) {
            start = 0;
        }
        if ((size = paginateRequest.getSize()) == null || size < 0) {
            size = 10;
        }
        if ((sort = paginateRequest.getSort()) == null) {
            sort = defaultSort;
        }
        if ((order = paginateRequest.getOrder()) == null) {
            order = "asc";
        }
        if (sort != null && properties != null && !properties.isEmpty()) {
            QueryProperty queryProperty = properties.get(sort);
            if (queryProperty == null) {
                throw new FlowableIllegalArgumentException("Value for param 'sort' is not valid, '" + sort + "' is not a valid property");
            }
            query.orderBy(queryProperty);
            if (order.equals("asc")) {
                query.asc();
            } else if (order.equals("desc")) {
                query.desc();
            } else {
                throw new FlowableIllegalArgumentException("Value for param 'order' is not valid : '" + order + "', must be 'asc' or 'desc'");
            }
        }
        DataResponse<RES> response = new DataResponse<RES>();
        response.setStart(start);
        response.setSort(sort);
        response.setOrder(order);
        List<RES> list = listProcessor.processList(query.listPage(start.intValue(), size.intValue()));
        if (start == 0 && list.size() < size) {
            response.setTotal(list.size());
        } else {
            response.setTotal(query.count());
        }
        response.setSize(list.size());
        response.setData(list);
        return response;
    }
}

