/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.CmmnModelJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.cmmn.model.ServiceTask;

public class ServiceTaskJsonConverter
extends BaseCmmnJsonConverter {
    protected static final Map<String, String> TYPE_TO_STENCILSET = new HashMap<String, String>();

    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        ServiceTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        ServiceTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ServiceTask", ServiceTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ServiceTask.class, ServiceTaskJsonConverter.class);
        convertersToJsonMap.put(HttpServiceTask.class, ServiceTaskJsonConverter.class);
        convertersToJsonMap.put(ScriptServiceTask.class, ServiceTaskJsonConverter.class);
        convertersToJsonMap.put(SendEventServiceTask.class, ServiceTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        ServiceTask serviceTask;
        String stencilId;
        PlanItem planItem;
        PlanItemDefinition planItemDefinition;
        if (baseElement instanceof PlanItem && (planItemDefinition = (planItem = (PlanItem)baseElement).getPlanItemDefinition()) instanceof ServiceTask && (stencilId = TYPE_TO_STENCILSET.get((serviceTask = (ServiceTask)planItemDefinition).getType())) != null) {
            return stencilId;
        }
        return "ServiceTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        ServiceTask serviceTask = (ServiceTask)((PlanItem)baseElement).getPlanItemDefinition();
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)serviceTask);
        if ("http".equalsIgnoreCase(serviceTask.getType())) {
            this.fillHttpJsonPropertyValues(serviceTask, propertiesNode);
        } else if ("script".equalsIgnoreCase(serviceTask.getType())) {
            this.fillScriptJsonPropertyValues(serviceTask, propertiesNode);
        } else if ("send-event".equalsIgnoreCase(serviceTask.getType())) {
            this.fillSendEventJsonPropertyValues(serviceTask, propertiesNode);
        } else if ("mail".equalsIgnoreCase(serviceTask.getType())) {
            this.fillMailJsonPropertyValues(serviceTask, propertiesNode);
        } else {
            if ("class".equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskclass", serviceTask.getImplementation());
            } else if ("expression".equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskexpression", serviceTask.getImplementation());
            } else if ("delegateExpression".equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskdelegateexpression", serviceTask.getImplementation());
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                propertiesNode.put("servicetaskresultvariable", serviceTask.getResultVariableName());
            }
            if (serviceTask.isStoreResultVariableAsTransient()) {
                propertiesNode.put("servicetaskstoreresultvariabletransient", serviceTask.isStoreResultVariableAsTransient());
            }
            this.addFieldExtensions(serviceTask.getFieldExtensions(), propertiesNode);
        }
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        JsonNode itemsArrayNode;
        JsonNode fieldsNode;
        ServiceTask task = new ServiceTask();
        task.setType("java");
        if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode))) {
            task.setImplementationType("class");
            task.setImplementation(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskexpression", elementNode))) {
            task.setImplementationType("expression");
            task.setImplementation(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskexpression", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskdelegateexpression", elementNode))) {
            task.setImplementationType("delegateExpression");
            task.setImplementation(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskdelegateexpression", elementNode));
        }
        if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskresultvariable", elementNode))) {
            task.setResultVariableName(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskresultvariable", elementNode));
        }
        if (CmmnJsonConverterUtil.getPropertyValueAsBoolean("servicetaskstoreresultvariabletransient", elementNode)) {
            task.setStoreResultVariableAsTransient(true);
        }
        if ((fieldsNode = CmmnJsonConverterUtil.getProperty("servicetaskfields", elementNode)) != null && (itemsArrayNode = fieldsNode.get("fields")) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode nameNode = itemNode.get("name");
                if (nameNode == null || !StringUtils.isNotEmpty((CharSequence)nameNode.asText())) continue;
                FieldExtension field = new FieldExtension();
                field.setFieldName(nameNode.asText());
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("stringValue", itemNode))) {
                    field.setStringValue(this.getValueAsString("stringValue", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("string", itemNode))) {
                    field.setStringValue(this.getValueAsString("string", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("expression", itemNode))) {
                    field.setExpression(this.getValueAsString("expression", itemNode));
                }
                task.getFieldExtensions().add(field);
            }
        }
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)task);
        return task;
    }

    protected void fillHttpJsonPropertyValues(ServiceTask serviceTask, ObjectNode propertiesNode) {
        Boolean parallelInSameTransaction;
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) {
            propertiesNode.put("servicetaskclass", serviceTask.getImplementation());
        }
        if ((parallelInSameTransaction = ((HttpServiceTask)serviceTask).getParallelInSameTransaction()) != null) {
            propertiesNode.put("httptaskparallelinsametransaction", parallelInSameTransaction.toString());
        }
        this.setPropertyFieldValue("httptaskrequestmethod", "requestMethod", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskrequesturl", "requestUrl", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskrequestheaders", "requestHeaders", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskrequestbody", "requestBody", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskrequestbodyencoding", "requestBodyEncoding", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskrequesttimeout", "requestTimeout", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskdisallowredirects", "disallowRedirects", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskfailstatuscodes", "failStatusCodes", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskhandlestatuscodes", "handleStatusCodes", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskresponsevariablename", "responseVariableName", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskignoreexception", "ignoreException", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptasksaverequestvariables", "saveRequestVariables", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptasksaveresponseparameters", "saveResponseParameters", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptaskresultvariableprefix", "resultVariablePrefix", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptasksaveresponseparameterstransient", "saveResponseParametersTransient", serviceTask, propertiesNode);
        this.setPropertyFieldValue("httptasksaveresponseasjson", "saveResponseVariableAsJson", serviceTask, propertiesNode);
    }

    protected void fillScriptJsonPropertyValues(ServiceTask serviceTask, ObjectNode propertiesNode) {
        propertiesNode.put("scriptformat", ((ScriptServiceTask)serviceTask).getScriptFormat());
        this.setPropertyFieldValue("scripttext", "scripttext", serviceTask, propertiesNode);
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
            propertiesNode.put("servicetaskresultvariable", serviceTask.getResultVariableName());
        }
    }

    protected void fillSendEventJsonPropertyValues(ServiceTask serviceTask, ObjectNode propertiesNode) {
        SendEventServiceTask sendEventServiceTask = (SendEventServiceTask)serviceTask;
        String eventType = sendEventServiceTask.getEventType();
        if (StringUtils.isNotEmpty((CharSequence)eventType)) {
            this.setPropertyValue("eventkey", sendEventServiceTask.getEventType(), propertiesNode);
            this.setPropertyValue("eventname", this.getExtensionValue("eventName", (PlanItemDefinition)sendEventServiceTask), propertiesNode);
            CmmnModelJsonConverterUtil.addEventInParameters((List)sendEventServiceTask.getExtensionElements().get("eventInParameter"), propertiesNode, this.objectMapper);
            this.setPropertyValue("channelkey", this.getExtensionValue("channelKey", (PlanItemDefinition)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("channelname", this.getExtensionValue("channelName", (PlanItemDefinition)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("channeltype", this.getExtensionValue("channelType", (PlanItemDefinition)sendEventServiceTask), propertiesNode);
            this.setPropertyValue("channeldestination", this.getExtensionValue("channelDestination", (PlanItemDefinition)sendEventServiceTask), propertiesNode);
        }
    }

    protected void fillMailJsonPropertyValues(ServiceTask serviceTask, ObjectNode propertiesNode) {
        this.setPropertyFieldValue("mailtaskheaders", "headers", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtaskto", "to", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtaskfrom", "from", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtasksubject", "subject", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtaskcc", "cc", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtaskbcc", "bcc", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtasktext", "text", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtaskhtml", "html", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtaskhtmlvar", "htmlVar", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtasktextvar", "textVar", serviceTask, propertiesNode);
        this.setPropertyFieldValue("mailtaskcharset", "charset", serviceTask, propertiesNode);
    }

    protected void setPropertyFieldValue(String propertyName, String fieldName, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!fieldName.equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(propertyName, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(propertyName, extension.getExpression(), propertiesNode);
        }
    }

    static {
        TYPE_TO_STENCILSET.put("http", "HttpTask");
        TYPE_TO_STENCILSET.put("script", "ScriptTask");
        TYPE_TO_STENCILSET.put("send-event", "SendEventTask");
        TYPE_TO_STENCILSET.put("mail", "MailTask");
    }
}

