/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseChildTaskCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ProcessTask;

public class ProcessTaskJsonConverter
extends BaseChildTaskCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        ProcessTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        ProcessTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ProcessTask", ProcessTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ProcessTask.class, ProcessTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "ProcessTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        String processRef;
        ProcessTask processTask = (ProcessTask)((PlanItem)baseElement).getPlanItemDefinition();
        if (processTask.getFallbackToDefaultTenant() != null) {
            propertiesNode.put("fallbacktodefaulttenant", processTask.getFallbackToDefaultTenant());
        }
        propertiesNode.put("samedeployment", processTask.isSameDeployment());
        if (StringUtils.isNotEmpty((CharSequence)processTask.getProcessInstanceIdVariableName())) {
            propertiesNode.put("idvariablename", processTask.getProcessInstanceIdVariableName());
        }
        if (StringUtils.isNotEmpty((CharSequence)(processRef = processTask.getProcessRef()))) {
            ObjectNode processReferenceNode = this.objectMapper.createObjectNode();
            processReferenceNode.put("key", processRef);
            propertiesNode.set("processtaskprocessreference", (JsonNode)processReferenceNode);
            Map<String, String> modelInfo = converterContext.getProcessModelInfoForProcessModelKey(processRef);
            if (modelInfo != null) {
                processReferenceNode.put("id", modelInfo.get("id"));
                processReferenceNode.put("name", modelInfo.get("name"));
            } else {
                converterContext.registerUnresolvedProcessModelReferenceForCaseModel(processRef, cmmnModel);
            }
        }
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)processTask);
        if (processTask.getInParameters() != null && !processTask.getInParameters().isEmpty()) {
            ObjectNode inParametersNode = propertiesNode.putObject("processtaskinparameters");
            ArrayNode inParametersArray = inParametersNode.putArray("inParameters");
            this.readIOParameters(processTask.getInParameters(), inParametersArray);
        }
        if (processTask.getOutParameters() != null && !processTask.getOutParameters().isEmpty()) {
            ObjectNode outParametersNode = propertiesNode.putObject("processtaskoutparameters");
            ArrayNode outParametersArray = outParametersNode.putArray("outParameters");
            this.readIOParameters(processTask.getOutParameters(), outParametersArray);
        }
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        JsonNode idVariableName;
        JsonNode sameDeployment;
        JsonNode fallbackToDefaultTenant;
        JsonNode processTaskOutParametersNode;
        JsonNode processTaskInParametersNode;
        ProcessTask task = new ProcessTask();
        JsonNode processModelReferenceNode = CmmnJsonConverterUtil.getProperty("processtaskprocessreference", elementNode);
        if (processModelReferenceNode != null && processModelReferenceNode.has("id") && !processModelReferenceNode.get("id").isNull()) {
            String processModelId = processModelReferenceNode.get("id").asText();
            String processModelKey = converterContext.getProcessModelKeyForProcessModelId(processModelId);
            if (StringUtils.isEmpty((CharSequence)processModelKey) && processModelReferenceNode.has("key")) {
                processModelKey = processModelReferenceNode.get("key").asText();
            }
            task.setProcessRef(processModelKey);
        }
        if ((processTaskInParametersNode = CmmnJsonConverterUtil.getProperty("processtaskinparameters", elementNode)) != null && processTaskInParametersNode.has("inParameters") && !processTaskInParametersNode.get("inParameters").isNull()) {
            JsonNode inParametersNode = processTaskInParametersNode.get("inParameters");
            task.setInParameters(this.readIOParameters(inParametersNode));
        }
        if ((processTaskOutParametersNode = CmmnJsonConverterUtil.getProperty("processtaskoutparameters", elementNode)) != null && processTaskOutParametersNode.has("outParameters") && !processTaskOutParametersNode.get("outParameters").isNull()) {
            JsonNode outParametersNode = processTaskOutParametersNode.get("outParameters");
            task.setOutParameters(this.readIOParameters(outParametersNode));
        }
        if ((fallbackToDefaultTenant = CmmnJsonConverterUtil.getProperty("fallbacktodefaulttenant", elementNode)) != null) {
            task.setFallbackToDefaultTenant(Boolean.valueOf(fallbackToDefaultTenant.booleanValue()));
        }
        if ((sameDeployment = CmmnJsonConverterUtil.getProperty("samedeployment", elementNode)) != null) {
            task.setSameDeployment(sameDeployment.booleanValue());
        }
        if ((idVariableName = CmmnJsonConverterUtil.getProperty("idvariablename", elementNode)) != null && idVariableName.isTextual()) {
            task.setProcessInstanceIdVariableName(idVariableName.asText());
        }
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)task);
        return task;
    }
}

