/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CaseModelAwareConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.DecisionTableAwareConverter;
import org.flowable.cmmn.editor.json.converter.DecisionTableKeyAwareConverter;
import org.flowable.cmmn.editor.json.converter.FormAwareConverter;
import org.flowable.cmmn.editor.json.converter.FormKeyAwareConverter;
import org.flowable.cmmn.editor.json.converter.ProcessModelAwareConverter;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.editor.json.model.CmmnModelInfo;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;

public class StageJsonConverter
extends BaseCmmnJsonConverter
implements FormAwareConverter,
FormKeyAwareConverter,
DecisionTableAwareConverter,
DecisionTableKeyAwareConverter,
CaseModelAwareConverter,
ProcessModelAwareConverter {
    protected Map<String, String> formMap;
    protected Map<String, CmmnModelInfo> formKeyMap;
    protected Map<String, String> decisionTableMap;
    protected Map<String, CmmnModelInfo> decisionTableKeyMap;
    protected Map<String, String> caseModelMap;
    protected Map<String, String> processModelMap;

    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        StageJsonConverter.fillJsonTypes(convertersToCmmnMap);
        StageJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap) {
        convertersToCmmnMap.put("Stage", StageJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(Stage.class, StageJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "Stage";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
        PlanItem planItem = (PlanItem)baseElement;
        Stage stage = (Stage)planItem.getPlanItemDefinition();
        if (stage.getDisplayOrder() != null) {
            propertiesNode.put("displayorder", stage.getDisplayOrder());
        }
        if (stage.isIncludeInStageOverview()) {
            propertiesNode.put("includeinstageoverview", true);
        }
        GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(planItem.getId());
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        processor.processPlanItems(stage, cmmnModel, subProcessShapesArrayNode, this.formKeyMap, this.decisionTableKeyMap, graphicInfo.getX(), graphicInfo.getY());
        elementNode.set("childShapes", (JsonNode)subProcessShapesArrayNode);
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)stage);
    }

    protected CaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        Stage stage = new Stage();
        stage.setId(CmmnJsonConverterUtil.getElementId(elementNode));
        stage.setAutoComplete(CmmnJsonConverterUtil.getPropertyValueAsBoolean("autocompleteenabled", elementNode));
        String autoCompleteCondition = CmmnJsonConverterUtil.getPropertyValueAsString("autocompletecondition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)autoCompleteCondition)) {
            stage.setAutoCompleteCondition(autoCompleteCondition);
        }
        stage.setDisplayOrder(CmmnJsonConverterUtil.getPropertyValueAsInteger("displayorder", elementNode));
        stage.setIncludeInStageOverview(CmmnJsonConverterUtil.getPropertyValueAsBoolean("includeinstageoverview", elementNode, true));
        JsonNode childShapesArray = elementNode.get("childShapes");
        processor.processJsonElements(childShapesArray, modelNode, (BaseElement)stage, shapeMap, this.formMap, this.decisionTableMap, this.caseModelMap, this.processModelMap, cmmnModel, cmmnModelIdHelper);
        Stage parentStage = (Stage)parentElement;
        stage.setParent((PlanFragment)parentStage);
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)stage);
        return stage;
    }

    @Override
    public void setFormMap(Map<String, String> formMap) {
        this.formMap = formMap;
    }

    @Override
    public void setFormKeyMap(Map<String, CmmnModelInfo> formKeyMap) {
        this.formKeyMap = formKeyMap;
    }

    @Override
    public void setDecisionTableMap(Map<String, String> decisionTableMap) {
        this.decisionTableMap = decisionTableMap;
    }

    @Override
    public void setDecisionTableKeyMap(Map<String, CmmnModelInfo> decisionTableKeyMap) {
        this.decisionTableKeyMap = decisionTableKeyMap;
    }

    @Override
    public void setCaseModelMap(Map<String, String> caseModelMap) {
        this.caseModelMap = caseModelMap;
    }

    @Override
    public void setProcessModelMap(Map<String, String> processModelMap) {
        this.processModelMap = processModelMap;
    }
}

