/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.Stage;

public class CriterionJsonConverter
extends BaseCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        CriterionJsonConverter.fillJsonTypes(convertersToCmmnMap);
        CriterionJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap) {
        convertersToCmmnMap.put("EntryCriterion", CriterionJsonConverter.class);
        convertersToCmmnMap.put("ExitCriterion", CriterionJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(Criterion.class, CriterionJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        Criterion criterion = (Criterion)baseElement;
        if (criterion.isEntryCriterion()) {
            return "EntryCriterion";
        }
        if (criterion.isExitCriterion()) {
            return "ExitCriterion";
        }
        return "EntryCriterion";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
        Criterion criterion = (Criterion)baseElement;
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(criterion.getId());
        GraphicInfo parentGraphicInfo = null;
        Stage planModel = cmmnModel.getPrimaryCase().getPlanModel();
        if (criterion.getAttachedToRefId() != null) {
            if (criterion.getAttachedToRefId().equals(planModel.getId())) {
                parentGraphicInfo = cmmnModel.getGraphicInfo(planModel.getId());
            } else {
                PlanItem parentPlanItem = cmmnModel.findPlanItem(criterion.getAttachedToRefId());
                parentGraphicInfo = cmmnModel.getGraphicInfo(parentPlanItem.getId());
            }
            dockNode.put("x", graphicInfo.getX() - parentGraphicInfo.getX());
            dockNode.put("y", graphicInfo.getY() - parentGraphicInfo.getY());
            dockersArrayNode.add((JsonNode)dockNode);
            elementNode.set("dockers", (JsonNode)dockersArrayNode);
            elementNode.set("outgoing", this.getOutgoingArrayNodes(criterion.getId(), cmmnModel));
        } else {
            elementNode.putArray("dockers");
            elementNode.putArray("outgoing");
        }
        this.putProperty(propertiesNode, "name", criterion.getSentry().getName());
        this.putProperty(propertiesNode, "documentation", criterion.getSentry().getDocumentation());
        if (criterion.getSentry() != null && criterion.getSentry().getSentryIfPart() != null) {
            this.putProperty(propertiesNode, "ifpartcondition", criterion.getSentry().getSentryIfPart().getCondition());
        }
    }

    protected JsonNode getOutgoingArrayNodes(String id, CmmnModel cmmnModel) {
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        for (Association association : cmmnModel.getAssociations()) {
            if (!id.equals(association.getSourceRef())) continue;
            outgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(association.getId()));
        }
        return outgoingArrayNode;
    }

    protected void putProperty(ObjectNode propertiesNode, String propertyName, String propertyValue) {
        if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
            propertiesNode.put(propertyName, propertyValue);
        }
    }

    protected CaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        Criterion criterion = new Criterion();
        String id = CmmnJsonConverterUtil.getElementId(elementNode);
        if (StringUtils.isBlank((CharSequence)id)) {
            id = "criterion_" + cmmnModelIdHelper.nextCriterionId();
        }
        criterion.setId(id);
        criterion.setTechnicalId(CmmnJsonConverterUtil.getShapeId(elementNode));
        String stencilId = CmmnJsonConverterUtil.getStencilId(elementNode);
        if ("EntryCriterion".equals(stencilId)) {
            criterion.setEntryCriterion(true);
        } else if ("ExitCriterion".equals(stencilId)) {
            criterion.setExitCriterion(true);
        }
        criterion.setAttachedToRefId(this.lookForAttachedRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes")));
        if (criterion.getAttachedToRefId() != null) {
            String criterionId = CmmnJsonConverterUtil.getElementId(elementNode);
            cmmnModel.addCriterion(criterionId, criterion);
            cmmnModel.addCriterionTechnicalId(criterion.getTechnicalId(), criterionId);
        }
        this.createSentry(elementNode, criterion, cmmnModelIdHelper);
        return criterion;
    }

    protected void createSentry(JsonNode elementNode, Criterion criterion, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        Sentry sentry = new Sentry();
        sentry.setId("sentry" + cmmnModelIdHelper.nextSentryId());
        sentry.setName(CmmnJsonConverterUtil.getPropertyValueAsString("name", elementNode));
        sentry.setDocumentation(CmmnJsonConverterUtil.getPropertyValueAsString("documentation", elementNode));
        String ifPartCondition = CmmnJsonConverterUtil.getPropertyValueAsString("ifpartcondition", elementNode);
        if (StringUtils.isNotBlank((CharSequence)ifPartCondition)) {
            SentryIfPart sentryIfPart = new SentryIfPart();
            sentryIfPart.setCondition(ifPartCondition);
            sentry.setSentryIfPart(sentryIfPart);
        }
        criterion.setSentryRef(sentry.getId());
        criterion.setSentry(sentry);
    }

    private String lookForAttachedRef(String criterionId, JsonNode childShapesNode) {
        String attachedRefId = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                ArrayNode outgoingNode = (ArrayNode)childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !criterionId.equals(resourceNode.asText())) continue;
                        attachedRefId = CmmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (attachedRefId != null) break;
                }
                if ((attachedRefId = this.lookForAttachedRef(criterionId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return attachedRefId;
    }
}

