/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.IdentityLinkQueryObject;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryProperty;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.CacheAwareQuery;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;

public class CaseInstanceQueryImpl
extends AbstractVariableQueryImpl<CaseInstanceQuery, CaseInstance>
implements CaseInstanceQuery,
CacheAwareQuery<CaseInstanceEntity> {
    private static final long serialVersionUID = 1L;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected Set<String> caseDefinitionKeys;
    protected Set<String> caseDefinitionIds;
    protected String caseDefinitionCategory;
    protected String caseDefinitionName;
    protected Integer caseDefinitionVersion;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected String rootScopeId;
    protected String parentScopeId;
    protected String businessKey;
    protected String businessStatus;
    protected String caseInstanceId;
    protected Set<String> caseInstanceIds;
    protected String caseInstanceParentId;
    protected String caseInstanceParentPlanItemInstanceId;
    protected Date startedBefore;
    protected Date startedAfter;
    protected String startedBy;
    protected String state;
    protected Date lastReactivatedBefore;
    protected Date lastReactivatedAfter;
    protected String lastReactivatedBy;
    protected String callbackId;
    protected String callbackType;
    protected String referenceId;
    protected String referenceType;
    protected boolean completeable;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean includeCaseVariables;
    protected String activePlanItemDefinitionId;
    protected Set<String> activePlanItemDefinitionIds;
    protected String involvedUser;
    protected IdentityLinkQueryObject involvedUserIdentityLink;
    protected Set<String> involvedGroups;
    private List<List<String>> safeInvolvedGroups;
    protected IdentityLinkQueryObject involvedGroupIdentityLink;
    protected List<CaseInstanceQueryImpl> orQueryObjects = new ArrayList<CaseInstanceQueryImpl>();
    protected CaseInstanceQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;
    protected String locale;
    protected boolean withLocalizationFallback;

    public CaseInstanceQueryImpl() {
    }

    public CaseInstanceQueryImpl(CommandContext commandContext, CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(commandContext, cmmnEngineConfiguration.getVariableServiceConfiguration());
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public CaseInstanceQueryImpl(CommandExecutor commandExecutor, CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(commandExecutor, cmmnEngineConfiguration.getVariableServiceConfiguration());
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    protected void ensureVariablesInitialized() {
        super.ensureVariablesInitialized();
        for (CaseInstanceQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    public CaseInstanceQueryImpl caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionId = caseDefinitionId;
        } else {
            this.caseDefinitionId = caseDefinitionId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionIds(Set<String> caseDefinitionIds) {
        if (caseDefinitionIds == null) {
            throw new FlowableIllegalArgumentException("Case definition ids is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionIds = caseDefinitionIds;
        } else {
            this.caseDefinitionIds = caseDefinitionIds;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionKey(String caseDefinitionKey) {
        if (caseDefinitionKey == null) {
            throw new FlowableIllegalArgumentException("Case definition key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKey = caseDefinitionKey;
        } else {
            this.caseDefinitionKey = caseDefinitionKey;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionCategory(String caseDefinitionCategory) {
        if (caseDefinitionCategory == null) {
            throw new FlowableIllegalArgumentException("Case definition category is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionCategory = caseDefinitionCategory;
        } else {
            this.caseDefinitionCategory = caseDefinitionCategory;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionName(String caseDefinitionName) {
        if (caseDefinitionName == null) {
            throw new FlowableIllegalArgumentException("Case definition name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionName = caseDefinitionName;
        } else {
            this.caseDefinitionName = caseDefinitionName;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionVersion(Integer caseDefinitionVersion) {
        if (caseDefinitionVersion == null) {
            throw new FlowableIllegalArgumentException("Case definition version is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionVersion = caseDefinitionVersion;
        } else {
            this.caseDefinitionVersion = caseDefinitionVersion;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceId = caseInstanceId;
        } else {
            this.caseInstanceId = caseInstanceId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceIds(Set<String> caseInstanceIds) {
        if (caseInstanceIds == null) {
            throw new FlowableIllegalArgumentException("Case instance ids is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceIds = caseInstanceIds;
        } else {
            this.caseInstanceIds = caseInstanceIds;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.name = name;
        } else {
            this.name = name;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("Name like is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.nameLike = nameLike;
        } else {
            this.nameLike = nameLike;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (nameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Name like ignore case is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.nameLikeIgnoreCase = nameLikeIgnoreCase;
        } else {
            this.nameLikeIgnoreCase = nameLikeIgnoreCase;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceRootScopeId(String rootScopeId) {
        if (rootScopeId == null) {
            throw new FlowableIllegalArgumentException("rootScopeId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.rootScopeId = rootScopeId;
        } else {
            this.rootScopeId = rootScopeId;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceParentScopeId(String parentScopeId) {
        if (parentScopeId == null) {
            throw new FlowableIllegalArgumentException("parentScopeId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.parentScopeId = parentScopeId;
        } else {
            this.parentScopeId = parentScopeId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceBusinessKey(String businessKey) {
        if (businessKey == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKey = businessKey;
        } else {
            this.businessKey = businessKey;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceBusinessStatus(String businessStatus) {
        if (businessStatus == null) {
            throw new FlowableIllegalArgumentException("Business status is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessStatus = businessStatus;
        } else {
            this.businessStatus = businessStatus;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionKeys(Set<String> caseDefinitionKeys) {
        if (caseDefinitionKeys == null) {
            throw new FlowableIllegalArgumentException("Case definition keys is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKeys = caseDefinitionKeys;
        } else {
            this.caseDefinitionKeys = caseDefinitionKeys;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceParentId(String parentId) {
        if (parentId == null) {
            throw new FlowableIllegalArgumentException("Parent id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceParentId = parentId;
        } else {
            this.caseInstanceParentId = parentId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceStartedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBefore = beforeTime;
        } else {
            this.startedBefore = beforeTime;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceStartedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedAfter = afterTime;
        } else {
            this.startedAfter = afterTime;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceStartedBy(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("user id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBy = userId;
        } else {
            this.startedBy = userId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceState(String state) {
        if (state == null) {
            throw new FlowableIllegalArgumentException("state is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.state = state;
        } else {
            this.state = state;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceLastReactivatedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastReactivatedBefore = beforeTime;
        } else {
            this.lastReactivatedBefore = beforeTime;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceLastReactivatedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastReactivatedAfter = afterTime;
        } else {
            this.lastReactivatedAfter = afterTime;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceLastReactivatedBy(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("user id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastReactivatedBy = userId;
        } else {
            this.lastReactivatedBy = userId;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceCallbackId(String callbackId) {
        if (callbackId == null) {
            throw new FlowableIllegalArgumentException("callbackId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackId = callbackId;
        } else {
            this.callbackId = callbackId;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceCallbackType(String callbackType) {
        if (callbackType == null) {
            throw new FlowableIllegalArgumentException("callbackType is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackType = callbackType;
        } else {
            this.callbackType = callbackType;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceReferenceId(String referenceId) {
        if (referenceId == null) {
            throw new FlowableIllegalArgumentException("referenceId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceId = referenceId;
        } else {
            this.referenceId = referenceId;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceReferenceType(String referenceType) {
        if (referenceType == null) {
            throw new FlowableIllegalArgumentException("referenceType is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceType = referenceType;
        } else {
            this.referenceType = referenceType;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceIsCompleteable() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.completeable = true;
        } else {
            this.completeable = true;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceWithoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    public CaseInstanceQuery activePlanItemDefinitionId(String planItemDefinitionId) {
        if (planItemDefinitionId == null) {
            throw new FlowableIllegalArgumentException("planItemDefinitionId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.activePlanItemDefinitionId = planItemDefinitionId;
        } else {
            this.activePlanItemDefinitionId = planItemDefinitionId;
        }
        return this;
    }

    public CaseInstanceQuery activePlanItemDefinitionIds(Set<String> planItemDefinitionIds) {
        if (planItemDefinitionIds == null) {
            throw new FlowableIllegalArgumentException("planItemDefinitionIds is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.activePlanItemDefinitionIds = planItemDefinitionIds;
        } else {
            this.activePlanItemDefinitionIds = planItemDefinitionIds;
        }
        return this;
    }

    public CaseInstanceQuery involvedUser(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("involvedUser is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedUser = userId;
        } else {
            this.involvedUser = userId;
        }
        return this;
    }

    public CaseInstanceQuery involvedUser(String userId, String identityLinkType) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("userId is null");
        }
        if (identityLinkType == null) {
            throw new FlowableIllegalArgumentException("identityLinkType is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedUserIdentityLink = new IdentityLinkQueryObject(userId, null, identityLinkType);
        } else {
            this.involvedUserIdentityLink = new IdentityLinkQueryObject(userId, null, identityLinkType);
        }
        return this;
    }

    public CaseInstanceQuery involvedGroup(String groupId, String identityLinkType) {
        if (groupId == null) {
            throw new FlowableIllegalArgumentException("groupId is null");
        }
        if (identityLinkType == null) {
            throw new FlowableIllegalArgumentException("identityLinkType is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedGroupIdentityLink = new IdentityLinkQueryObject(null, groupId, identityLinkType);
        } else {
            this.involvedGroupIdentityLink = new IdentityLinkQueryObject(null, groupId, identityLinkType);
        }
        return this;
    }

    public CaseInstanceQuery involvedGroups(Set<String> groupIds) {
        if (groupIds == null) {
            throw new FlowableIllegalArgumentException("involvedGroups are null");
        }
        if (groupIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("involvedGroups are empty");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedGroups = groupIds;
        } else {
            this.involvedGroups = groupIds;
        }
        return this;
    }

    public CaseInstanceQuery or() {
        if (this.inOrStatement) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = this.commandContext != null ? new CaseInstanceQueryImpl(this.commandContext, this.cmmnEngineConfiguration) : new CaseInstanceQueryImpl(this.commandExecutor, this.cmmnEngineConfiguration);
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    public CaseInstanceQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    public CaseInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    public CaseInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    public CaseInstanceQuery variableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueEquals(variableValue, false);
    }

    public CaseInstanceQuery variableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    public CaseInstanceQuery variableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    public CaseInstanceQuery variableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    public CaseInstanceQuery variableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    public CaseInstanceQuery variableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    public CaseInstanceQuery variableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    public CaseInstanceQuery variableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLike(name, value, false);
    }

    public CaseInstanceQuery variableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    public CaseInstanceQuery variableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableExists(name, false);
    }

    public CaseInstanceQuery variableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableNotExists(name, false);
    }

    public CaseInstanceQueryImpl orderByCaseInstanceId() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_INSTANCE_ID;
        return this;
    }

    public CaseInstanceQueryImpl orderByCaseDefinitionId() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_DEFINITION_ID;
        return this;
    }

    public CaseInstanceQueryImpl orderByCaseDefinitionKey() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_DEFINITION_KEY;
        return this;
    }

    public CaseInstanceQueryImpl orderByStartTime() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_START_TIME;
        return this;
    }

    public CaseInstanceQueryImpl orderByTenantId() {
        this.orderProperty = CaseInstanceQueryProperty.TENANT_ID;
        return this;
    }

    public CaseInstanceQueryImpl includeCaseVariables() {
        this.includeCaseVariables = true;
        return this;
    }

    public CaseInstanceQuery locale(String locale) {
        this.locale = locale;
        return this;
    }

    public CaseInstanceQuery withLocalizationFallback() {
        this.withLocalizationFallback = true;
        return this;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return this.cmmnEngineConfiguration.getCaseInstanceEntityManager().countByCriteria(this);
    }

    public List<CaseInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        List<CaseInstance> caseInstances = null;
        caseInstances = this.isIncludeCaseVariables() ? this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findWithVariablesByCriteria(this) : this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findByCriteria(this);
        if (this.cmmnEngineConfiguration.getCaseLocalizationManager() != null) {
            for (CaseInstance caseInstance : caseInstances) {
                this.cmmnEngineConfiguration.getCaseLocalizationManager().localize(caseInstance, this.locale, this.withLocalizationFallback);
            }
        }
        return caseInstances;
    }

    public void enhanceCachedValue(CaseInstanceEntity caseInstance) {
        if (this.isIncludeCaseVariables()) {
            caseInstance.getQueryVariables().addAll(this.cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService().findVariableInstanceByScopeIdAndScopeType(caseInstance.getId(), "cmmn"));
        }
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionCategory() {
        return this.caseDefinitionCategory;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public Integer getCaseDefinitionVersion() {
        return this.caseDefinitionVersion;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getId() {
        return this.caseInstanceId;
    }

    public Set<String> getCaseInstanceIds() {
        return this.caseInstanceIds;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getBusinessStatus() {
        return this.businessStatus;
    }

    public Date getLastReactivatedBefore() {
        return this.lastReactivatedBefore;
    }

    public Date getLastReactivatedAfter() {
        return this.lastReactivatedAfter;
    }

    public String getLastReactivatedBy() {
        return this.lastReactivatedBy;
    }

    public String getExecutionId() {
        return this.caseInstanceId;
    }

    public Set<String> getCaseDefinitionIds() {
        return this.caseDefinitionIds;
    }

    public Set<String> getCaseDefinitionKeys() {
        return this.caseDefinitionKeys;
    }

    public String getParentId() {
        return this.caseInstanceParentId;
    }

    public String getCaseInstanceParentPlanItemInstanceId() {
        return this.caseInstanceParentPlanItemInstanceId;
    }

    public String getCaseInstanceParentId() {
        return this.caseInstanceParentId;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getState() {
        return this.state;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public boolean isCompleteable() {
        return this.completeable;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getActivePlanItemDefinitionId() {
        return this.activePlanItemDefinitionId;
    }

    public Set<String> getActivePlanItemDefinitionIds() {
        return this.activePlanItemDefinitionIds;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public IdentityLinkQueryObject getInvolvedUserIdentityLink() {
        return this.involvedUserIdentityLink;
    }

    public IdentityLinkQueryObject getInvolvedGroupIdentityLink() {
        return this.involvedGroupIdentityLink;
    }

    public Set<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public boolean isIncludeCaseVariables() {
        return this.includeCaseVariables;
    }

    public boolean isNeedsCaseDefinitionOuterJoin() {
        if (this.isNeedsPaging() && ("oracle".equals(this.databaseType) || "db2".equals(this.databaseType) || "mssql".equals(this.databaseType))) {
            return false;
        }
        return this.hasOrderByForColumn(CaseInstanceQueryProperty.CASE_DEFINITION_KEY.getName());
    }

    public List<CaseInstanceQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }

    public List<List<String>> getSafeInvolvedGroups() {
        return this.safeInvolvedGroups;
    }

    public void setSafeInvolvedGroups(List<List<String>> safeInvolvedGroups) {
        this.safeInvolvedGroups = safeInvolvedGroups;
    }
}

