/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.List;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.listener.PlanItemInstanceLifecycleListener;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;

public class DelegateExpressionPlanItemLifecycleListener
implements PlanItemInstanceLifecycleListener {
    protected String sourceState;
    protected String targetState;
    protected Expression expression;
    protected List<FieldExtension> fieldExtensions;

    public DelegateExpressionPlanItemLifecycleListener(String sourceState, String targetState, Expression expression, List<FieldExtension> fieldExtensions) {
        this.sourceState = sourceState;
        this.targetState = targetState;
        this.expression = expression;
        this.fieldExtensions = fieldExtensions;
    }

    public String getSourceState() {
        return this.sourceState;
    }

    public String getTargetState() {
        return this.targetState;
    }

    public void stateChanged(DelegatePlanItemInstance planItemInstance, String oldState, String newState) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableContainer)planItemInstance, this.fieldExtensions);
        if (!(delegate instanceof PlanItemInstanceLifecycleListener)) {
            throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + PlanItemInstanceLifecycleListener.class);
        }
        PlanItemInstanceLifecycleListener listener = (PlanItemInstanceLifecycleListener)delegate;
        listener.stateChanged(planItemInstance, oldState, newState);
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

