/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delete;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.job.service.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.QueryOperator;

public class BatchDeleteCaseConfig {
    protected final Batch batch;
    protected final BatchPart batchPart;
    protected final String error;
    protected final boolean sequentialExecution;
    protected int batchSize;
    protected HistoricCaseInstanceQuery query;

    protected BatchDeleteCaseConfig(Batch batch, BatchPart batchPart, String error, boolean sequentialExecution) {
        this.batch = batch;
        this.batchPart = batchPart;
        this.error = error;
        this.sequentialExecution = sequentialExecution;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public BatchPart getBatchPart() {
        return this.batchPart;
    }

    public String getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean isSequentialExecution() {
        return this.sequentialExecution;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public HistoricCaseInstanceQuery getQuery() {
        return this.query;
    }

    public static BatchDeleteCaseConfig create(String batchPartId, CmmnEngineConfiguration engineConfiguration) {
        HistoricCaseInstanceQuery query;
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchPart batchPart = batchService.getBatchPart(batchPartId);
        if (batchPart == null) {
            throw new FlowableIllegalArgumentException("There is no batch part with the id " + batchPartId);
        }
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        JsonNode batchConfiguration = BatchDeleteCaseConfig.getBatchConfiguration(batch, engineConfiguration);
        boolean sequentialExecution = batchConfiguration.path("sequential").booleanValue();
        JsonNode queryNode = batchConfiguration.path("query");
        if (queryNode.isMissingNode()) {
            return new BatchDeleteCaseConfig(batch, batchPart, BatchDeleteCaseConfig.prepareFailedResultAsJsonString("Batch configuration has no query definition", engineConfiguration), sequentialExecution);
        }
        JsonNode batchSizeNode = batchConfiguration.path("batchSize");
        if (batchSizeNode.isMissingNode()) {
            return new BatchDeleteCaseConfig(batch, batchPart, BatchDeleteCaseConfig.prepareFailedResultAsJsonString("Batch configuration has no batch size", engineConfiguration), sequentialExecution);
        }
        try {
            query = BatchDeleteCaseConfig.createQuery(queryNode, engineConfiguration);
        }
        catch (FlowableException exception) {
            return new BatchDeleteCaseConfig(batch, batchPart, BatchDeleteCaseConfig.prepareFailedResultAsJsonString("Failed to create query", exception, engineConfiguration), sequentialExecution);
        }
        BatchDeleteCaseConfig config = new BatchDeleteCaseConfig(batch, batchPart, null, sequentialExecution);
        config.batchSize = batchSizeNode.intValue();
        config.query = query;
        return config;
    }

    protected static HistoricCaseInstanceQuery createQuery(JsonNode queryNode, CmmnEngineConfiguration engineConfiguration) {
        HistoricCaseInstanceQuery query = engineConfiguration.getCmmnHistoryService().createHistoricCaseInstanceQuery();
        BatchDeleteCaseConfig.populateQuery(queryNode, query, engineConfiguration);
        if (queryNode.hasNonNull("finishedBefore") || queryNode.hasNonNull("finishedAfter") || queryNode.path("finished").asBoolean(false)) {
            query.orderByEndTime().asc();
        }
        return query;
    }

    protected static void populateQuery(JsonNode queryNode, HistoricCaseInstanceQuery query, CmmnEngineConfiguration engineConfiguration) {
        Iterator fieldIterator = queryNode.fields();
        block94: while (fieldIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIterator.next();
            String property = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            switch (property) {
                case "caseDefinitionId": {
                    query.caseDefinitionId(value.textValue());
                    continue block94;
                }
                case "caseDefinitionKey": {
                    query.caseDefinitionKey(value.textValue());
                    continue block94;
                }
                case "caseDefinitionKeys": {
                    query.caseDefinitionKeys(BatchDeleteCaseConfig.asStringSet(value));
                    continue block94;
                }
                case "caseDefinitionIds": {
                    query.caseDefinitionIds(BatchDeleteCaseConfig.asStringSet(value));
                    continue block94;
                }
                case "caseDefinitionName": {
                    query.caseDefinitionName(value.textValue());
                    continue block94;
                }
                case "caseDefinitionCategory": {
                    query.caseDefinitionCategory(value.textValue());
                    continue block94;
                }
                case "caseDefinitionVersion": {
                    query.caseDefinitionVersion(Integer.valueOf(value.intValue()));
                    continue block94;
                }
                case "caseInstanceId": {
                    query.caseInstanceId(value.textValue());
                    continue block94;
                }
                case "caseInstanceIds": {
                    query.caseInstanceIds(BatchDeleteCaseConfig.asStringSet(value));
                    continue block94;
                }
                case "caseInstanceName": {
                    query.caseInstanceName(value.textValue());
                }
                case "caseInstanceNameLike": {
                    query.caseInstanceNameLike(value.textValue());
                }
                case "caseInstanceNameLikeIgnoreCase": {
                    query.caseInstanceNameLikeIgnoreCase(value.textValue());
                    continue block94;
                }
                case "businessKey": {
                    query.caseInstanceBusinessKey(value.textValue());
                    continue block94;
                }
                case "businessStatus": {
                    query.caseInstanceBusinessStatus(value.textValue());
                    continue block94;
                }
                case "caseInstanceParentId": {
                    query.caseInstanceParentId(value.textValue());
                    continue block94;
                }
                case "withoutCaseInstanceParentId": {
                    if (!value.booleanValue()) continue block94;
                    query.withoutCaseInstanceParent();
                    continue block94;
                }
                case "deploymentId": {
                    query.deploymentId(value.textValue());
                    continue block94;
                }
                case "deploymentIds": {
                    query.deploymentIds(BatchDeleteCaseConfig.asStringList(value));
                    continue block94;
                }
                case "finished": {
                    if (!value.booleanValue()) continue block94;
                    query.finished();
                    continue block94;
                }
                case "unfinished": {
                    if (!value.booleanValue()) continue block94;
                    query.unfinished();
                    continue block94;
                }
                case "startedBefore": {
                    query.startedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block94;
                }
                case "startedAfter": {
                    query.startedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block94;
                }
                case "finishedBefore": {
                    query.finishedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block94;
                }
                case "finishedAfter": {
                    query.finishedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block94;
                }
                case "startedBy": {
                    query.startedBy(value.textValue());
                    continue block94;
                }
                case "lastReactivatedBefore": {
                    query.lastReactivatedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block94;
                }
                case "lastReactivatedAfter": {
                    query.lastReactivatedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                }
                case "lastReactivatedBy": {
                    query.lastReactivatedBy(value.textValue());
                    continue block94;
                }
                case "callbackId": {
                    query.caseInstanceCallbackId(value.textValue());
                    continue block94;
                }
                case "callbackType": {
                    query.caseInstanceCallbackType(value.textValue());
                    continue block94;
                }
                case "withoutCallbackId": {
                    if (!value.booleanValue()) continue block94;
                    query.withoutCaseInstanceCallbackId();
                    continue block94;
                }
                case "referenceId": {
                    query.caseInstanceReferenceId(value.textValue());
                    continue block94;
                }
                case "referenceType": {
                    query.caseInstanceReferenceType(value.textValue());
                    continue block94;
                }
                case "tenantId": {
                    query.caseInstanceTenantId(value.textValue());
                    continue block94;
                }
                case "withoutTenantId": {
                    if (!value.booleanValue()) continue block94;
                    query.caseInstanceWithoutTenantId();
                    continue block94;
                }
                case "activePlanItemDefinitionId": {
                    query.activePlanItemDefinitionId(value.textValue());
                    continue block94;
                }
                case "activePlanItemDefinitionIds": {
                    query.activePlanItemDefinitionIds(BatchDeleteCaseConfig.asStringSet(value));
                    continue block94;
                }
                case "involvedUser": {
                    query.involvedUser(value.textValue());
                    continue block94;
                }
                case "involvedUserIdentityLink": {
                    query.involvedUser(value.path("userId").textValue(), value.path("type").textValue());
                    continue block94;
                }
                case "involvedGroups": {
                    query.involvedGroups(BatchDeleteCaseConfig.asStringSet(value));
                    continue block94;
                }
                case "involvedGroupIdentityLink": {
                    query.involvedUser(value.path("groupId").textValue(), value.path("type").textValue());
                    continue block94;
                }
                case "queryVariableValues": {
                    BatchDeleteCaseConfig.populateQueryVariableValues(value, query, engineConfiguration);
                    continue block94;
                }
                case "orQueryObjects": {
                    BatchDeleteCaseConfig.populateOrQueryObjects(value, query, engineConfiguration);
                    continue block94;
                }
                case "caseInstanceRootScopeId": {
                    query.caseInstanceRootScopeId(value.textValue());
                    continue block94;
                }
                case "caseInstanceParentScopeId": {
                    query.caseInstanceParentScopeId(value.textValue());
                    continue block94;
                }
            }
            throw new FlowableIllegalArgumentException("Query property " + property + " is not supported");
        }
    }

    protected static void populateOrQueryObjects(JsonNode orQueryObjectsNode, HistoricCaseInstanceQuery query, CmmnEngineConfiguration engineConfiguration) {
        if (orQueryObjectsNode.isArray()) {
            for (JsonNode orQueryObjectNode : orQueryObjectsNode) {
                HistoricCaseInstanceQuery orQuery = query.or();
                BatchDeleteCaseConfig.populateQuery(orQueryObjectNode, orQuery, engineConfiguration);
                query.endOr();
            }
        }
    }

    protected static void populateQueryVariableValues(JsonNode variableValuesNode, HistoricCaseInstanceQuery query, CmmnEngineConfiguration engineConfiguration) {
        if (variableValuesNode.isArray()) {
            block13: for (JsonNode variableValue : variableValuesNode) {
                String operatorString = variableValue.path("operator").asText(null);
                if (operatorString == null) {
                    throw new FlowableIllegalArgumentException("The variable value does not contain an operator value");
                }
                QueryOperator operator = QueryOperator.valueOf((String)operatorString);
                String variableName = variableValue.path("name").textValue();
                switch (operator) {
                    case EQUALS: {
                        if (variableName != null) {
                            query.variableValueEquals(variableName, BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                            continue block13;
                        }
                        query.variableValueEquals(BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case NOT_EQUALS: {
                        query.variableValueNotEquals(variableName, BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case GREATER_THAN: {
                        query.variableValueGreaterThan(variableName, BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        query.variableValueGreaterThanOrEqual(variableName, BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LESS_THAN: {
                        query.variableValueLessThan(variableName, BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        query.variableValueLessThanOrEqual(variableName, BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LIKE: {
                        query.variableValueLike(variableName, (String)BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LIKE_IGNORE_CASE: {
                        query.variableValueLikeIgnoreCase(variableName, (String)BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case EQUALS_IGNORE_CASE: {
                        query.variableValueEqualsIgnoreCase(variableName, (String)BatchDeleteCaseConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case EXISTS: {
                        query.variableExists(variableName);
                        continue block13;
                    }
                    case NOT_EXISTS: {
                        query.variableNotExists(variableName);
                        continue block13;
                    }
                }
                throw new FlowableIllegalArgumentException("Operator " + operator + " is not supported for the variable value");
            }
        }
    }

    protected static Object extractVariableValue(JsonNode variableValueNode, CmmnEngineConfiguration engineConfiguration) {
        String type = variableValueNode.path("type").asText(null);
        if (type == null) {
            throw new FlowableIllegalArgumentException("The variable value does not have a type");
        }
        VariableType variableType = engineConfiguration.getVariableTypes().getVariableType(type);
        return variableType.getValue((ValueFields)new VariableValueJsonNodeValueFields(variableValueNode));
    }

    protected static List<String> asStringList(JsonNode node) {
        if (node != null && node.isArray() && node.size() > 0) {
            ArrayList<String> values = new ArrayList<String>(node.size());
            for (JsonNode element : node) {
                values.add(element.textValue());
            }
            return values;
        }
        return null;
    }

    protected static Set<String> asStringSet(JsonNode node) {
        if (node != null && node.isArray() && node.size() > 0) {
            ArrayList<String> values = new ArrayList<String>(node.size());
            for (JsonNode element : node) {
                values.add(element.textValue());
            }
            return new HashSet<String>(values);
        }
        return null;
    }

    protected static JsonNode getBatchConfiguration(Batch batch, CmmnEngineConfiguration engineConfiguration) {
        try {
            return engineConfiguration.getObjectMapper().readTree(batch.getBatchDocumentJson("cfg.cmmnEngine"));
        }
        catch (JsonProcessingException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
            return null;
        }
    }

    protected static String prepareFailedResultAsJsonString(String errorMessage, CmmnEngineConfiguration engineConfiguration) {
        return BatchDeleteCaseConfig.prepareFailedResultAsJsonString(errorMessage, null, engineConfiguration);
    }

    protected static String prepareFailedResultAsJsonString(String errorMessage, FlowableException exception, CmmnEngineConfiguration engineConfiguration) {
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        resultNode.put("errorMessage", errorMessage);
        if (exception != null) {
            resultNode.put("errorStacktrace", ExceptionUtils.getStackTrace((Throwable)exception));
        }
        return resultNode.toString();
    }

    protected static class VariableValueJsonNodeValueFields
    implements ValueFields {
        protected final JsonNode node;

        public VariableValueJsonNodeValueFields(JsonNode node) {
            this.node = node;
        }

        public String getName() {
            return this.node.path("name").textValue();
        }

        public String getProcessInstanceId() {
            throw new UnsupportedOperationException("Not supported to get process instance id");
        }

        public String getExecutionId() {
            throw new UnsupportedOperationException("Not supported to get execution id");
        }

        public String getScopeId() {
            throw new UnsupportedOperationException("Not supported to get scope id");
        }

        public String getSubScopeId() {
            throw new UnsupportedOperationException("Not supported to get sub scope id");
        }

        public String getScopeType() {
            throw new UnsupportedOperationException("Not supported to scope type");
        }

        public String getTaskId() {
            throw new UnsupportedOperationException("Not supported to get task id");
        }

        public String getTextValue() {
            return this.node.path("textValue").textValue();
        }

        public void setTextValue(String textValue) {
            throw new UnsupportedOperationException("Not supported to set text value");
        }

        public String getTextValue2() {
            return this.node.path("textValues").textValue();
        }

        public void setTextValue2(String textValue2) {
            throw new UnsupportedOperationException("Not supported to set text value2");
        }

        public Long getLongValue() {
            JsonNode longNode = this.node.path("longValue");
            if (longNode.isNumber()) {
                return longNode.longValue();
            }
            return null;
        }

        public void setLongValue(Long longValue) {
            throw new UnsupportedOperationException("Not supported to set long value");
        }

        public Double getDoubleValue() {
            JsonNode doubleNode = this.node.path("doubleValue");
            if (doubleNode.isNumber()) {
                return doubleNode.doubleValue();
            }
            return null;
        }

        public void setDoubleValue(Double doubleValue) {
            throw new UnsupportedOperationException("Not supported to set double value");
        }

        public byte[] getBytes() {
            throw new UnsupportedOperationException("Not supported to get bytes");
        }

        public void setBytes(byte[] bytes) {
            throw new UnsupportedOperationException("Not supported to set bytes");
        }

        public Object getCachedValue() {
            throw new UnsupportedOperationException("Not supported to set get cached value");
        }

        public void setCachedValue(Object cachedValue) {
            throw new UnsupportedOperationException("Not supported to set cached value");
        }
    }
}

