/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetVariablesCmd
implements Command<Void> {
    protected String caseInstanceId;
    protected Map<String, Object> variables;

    public SetVariablesCmd(String caseInstanceId, Map<String, Object> variables) {
        this.caseInstanceId = caseInstanceId;
        this.variables = variables;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        if (this.variables == null) {
            throw new FlowableIllegalArgumentException("variables is null");
        }
        if (this.variables.isEmpty()) {
            throw new FlowableIllegalArgumentException("variables is empty");
        }
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        caseInstanceEntity.setVariables(this.variables);
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        agenda.planEvaluateVariableEventListenersOperation(this.caseInstanceId);
        agenda.planEvaluateCriteriaOperation(this.caseInstanceId);
        return null;
    }
}

